/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.privilege.ImmutablePrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;

class PrivilegeDefinitionWriter
implements PrivilegeConstants {
    private final Root root;
    private final PrivilegeBitsProvider bitsMgr;
    private PrivilegeBits next;

    PrivilegeDefinitionWriter(Root root) {
        this.root = root;
        this.bitsMgr = new PrivilegeBitsProvider(root);
        Tree privilegesTree = this.bitsMgr.getPrivilegesTree();
        this.next = privilegesTree.exists() && privilegesTree.hasProperty("rep:next") ? PrivilegeBits.getInstance((Tree)privilegesTree) : PrivilegeBits.NEXT_AFTER_BUILT_INS;
    }

    void writeDefinition(PrivilegeDefinition definition) throws RepositoryException {
        this.writeDefinitions(Collections.singleton(definition));
    }

    void writeBuiltInDefinitions() throws RepositoryException {
        this.writeDefinitions(PrivilegeDefinitionWriter.getBuiltInDefinitions());
    }

    @Nonnull
    private PrivilegeBits getNext() {
        return this.next;
    }

    @Nonnull
    private PrivilegeBits next() {
        PrivilegeBits bits = this.next;
        this.next = bits.nextBits();
        return bits;
    }

    private void writeDefinitions(Iterable<PrivilegeDefinition> definitions) throws RepositoryException {
        try {
            Tree privilegesTree = this.root.getTree("/jcr:system/rep:privileges");
            if (!privilegesTree.exists()) {
                throw new RepositoryException("Privilege store does not exist.");
            }
            for (PrivilegeDefinition definition : definitions) {
                if (privilegesTree.hasChild(definition.getName())) {
                    throw new RepositoryException("Privilege definition with name '" + definition.getName() + "' already exists.");
                }
                this.writePrivilegeNode(privilegesTree, definition);
            }
            this.getNext().writeTo(privilegesTree);
            this.root.commit();
        }
        catch (CommitFailedException e) {
            throw e.asRepositoryException();
        }
    }

    private void writePrivilegeNode(Tree privilegesTree, PrivilegeDefinition definition) throws RepositoryException {
        Set declAggrNames;
        boolean isAggregate;
        String name = definition.getName();
        Tree privNode = TreeUtil.addChild((Tree)privilegesTree, (String)name, (String)"rep:Privilege");
        if (definition.isAbstract()) {
            privNode.setProperty("rep:isAbstract", (Object)true);
        }
        boolean bl = isAggregate = (declAggrNames = definition.getDeclaredAggregateNames()).size() > 0;
        if (isAggregate) {
            privNode.setProperty("rep:aggregates", (Object)declAggrNames, Type.NAMES);
        }
        PrivilegeBits bits = PrivilegeBits.BUILT_IN.containsKey(name) ? (PrivilegeBits)PrivilegeBits.BUILT_IN.get(name) : (isAggregate ? this.bitsMgr.getBits((Iterable)declAggrNames) : this.next());
        bits.writeTo(privNode);
    }

    private static Collection<PrivilegeDefinition> getBuiltInDefinitions() {
        ImmutablePrivilegeDefinition def;
        LinkedHashMap<String, ImmutablePrivilegeDefinition> definitions = new LinkedHashMap<String, ImmutablePrivilegeDefinition>();
        for (String privilegeName : NON_AGGREGATE_PRIVILEGES) {
            def = new ImmutablePrivilegeDefinition(privilegeName, false, null);
            definitions.put(privilegeName, def);
        }
        for (String privilegeName : AGGREGATE_PRIVILEGES.keySet()) {
            def = new ImmutablePrivilegeDefinition(privilegeName, false, Arrays.asList((Object[])AGGREGATE_PRIVILEGES.get(privilegeName)));
            definitions.put(privilegeName, def);
        }
        ImmutablePrivilegeDefinition all = new ImmutablePrivilegeDefinition("jcr:all", false, definitions.keySet());
        definitions.put("jcr:all", all);
        return definitions.values();
    }
}

