/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.util.Text;

final class PrivilegeContext
implements Context,
PrivilegeConstants {
    private static final Context INSTANCE = new PrivilegeContext();

    private PrivilegeContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    public boolean definesProperty(@Nonnull Tree parent, @Nonnull PropertyState property) {
        return PRIVILEGE_PROPERTY_NAMES.contains(property.getName()) && this.definesTree(parent);
    }

    public boolean definesContextRoot(@Nonnull Tree tree) {
        return "rep:privileges".equals(tree.getName()) && "rep:Privileges".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public boolean definesTree(@Nonnull Tree tree) {
        return PRIVILEGE_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public boolean definesLocation(@Nonnull TreeLocation location) {
        return Text.isDescendantOrEqual((String)"/jcr:system/rep:privileges", (String)location.getPath());
    }

    public boolean definesInternal(@Nonnull Tree tree) {
        return false;
    }
}

