/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import com.google.common.collect.Lists;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.restriction.WhiteboardRestrictionProvider;
import org.apache.jackrabbit.oak.security.internal.ConfigurationInitializer;
import org.apache.jackrabbit.oak.security.internal.InternalSecurityProvider;
import org.apache.jackrabbit.oak.security.internal.Preconditions;
import org.apache.jackrabbit.oak.security.user.UserConfigurationImpl;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardAuthorizableActionProvider;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardAuthorizableNodeName;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardUserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Designate(ocd=Configuration.class)
public class SecurityProviderRegistration {
    private static final Logger log = LoggerFactory.getLogger(SecurityProviderRegistration.class);
    private AuthenticationConfiguration authenticationConfiguration;
    private PrivilegeConfiguration privilegeConfiguration;
    private UserConfiguration userConfiguration;
    private BundleContext context;
    private ServiceRegistration registration;
    private boolean registering;
    private final Preconditions preconditions = new Preconditions();
    private final CompositeAuthorizationConfiguration authorizationConfiguration = new CompositeAuthorizationConfiguration();
    private final CompositePrincipalConfiguration principalConfiguration = new CompositePrincipalConfiguration();
    private final CompositeTokenConfiguration tokenConfiguration = new CompositeTokenConfiguration();
    private final List<AuthorizableNodeName> authorizableNodeNames = Lists.newCopyOnWriteArrayList();
    private final List<AuthorizableActionProvider> authorizableActionProviders = Lists.newCopyOnWriteArrayList();
    private final List<RestrictionProvider> restrictionProviders = Lists.newCopyOnWriteArrayList();
    private final List<UserAuthenticationFactory> userAuthenticationFactories = Lists.newCopyOnWriteArrayList();
    private RootProvider rootProvider;
    private TreeProvider treeProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(BundleContext context, Configuration configuration) {
        String[] requiredServicePids = configuration.requiredServicePids();
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            for (String pid : requiredServicePids) {
                this.preconditions.addPrecondition(pid);
            }
            this.context = context;
        }
        this.authorizationConfiguration.withCompositionType(configuration.authorizationCompositionType());
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    public void modified(Configuration configuration) {
        String[] requiredServicePids = configuration.requiredServicePids();
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.preconditions.clearPreconditions();
            for (String pid : requiredServicePids) {
                this.preconditions.addPrecondition(pid);
            }
        }
        this.authorizationConfiguration.withCompositionType(configuration.authorizationCompositionType());
        this.maybeUnregister();
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        ServiceRegistration registration;
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            registration = this.registration;
            this.registration = null;
            this.registering = false;
            this.context = null;
            this.preconditions.clearPreconditions();
        }
        if (registration != null) {
            registration.unregister();
        }
    }

    @Reference(name="authenticationConfiguration")
    public void bindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public void unbindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = null;
    }

    @Reference(name="privilegeConfiguration")
    public void bindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = privilegeConfiguration;
    }

    public void unbindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = null;
    }

    @Reference(name="userConfiguration")
    public void bindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    public void unbindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = null;
    }

    @Reference(name="rootProvider")
    public void bindRootProvider(RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    public void unbindRootProvider(RootProvider rootProvider) {
        this.rootProvider = null;
    }

    @Reference(name="treeProvider")
    public void bindTreeProvider(TreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    public void unbindTreeProvider(TreeProvider treeProvider) {
        this.treeProvider = null;
    }

    @Reference(name="authorizationConfiguration", service=AuthorizationConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAuthorizationConfiguration(AuthorizationConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration(this.authorizationConfiguration, (SecurityConfiguration)configuration, properties);
    }

    public void unbindAuthorizationConfiguration(AuthorizationConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration(this.authorizationConfiguration, (SecurityConfiguration)configuration, properties);
    }

    @Reference(name="principalConfiguration", service=PrincipalConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindPrincipalConfiguration(PrincipalConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration((CompositeConfiguration)this.principalConfiguration, (SecurityConfiguration)configuration, properties);
    }

    public void unbindPrincipalConfiguration(PrincipalConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration((CompositeConfiguration)this.principalConfiguration, (SecurityConfiguration)configuration, properties);
    }

    @Reference(name="tokenConfiguration", service=TokenConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindTokenConfiguration(TokenConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration((CompositeConfiguration)this.tokenConfiguration, (SecurityConfiguration)configuration, properties);
    }

    public void unbindTokenConfiguration(TokenConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration((CompositeConfiguration)this.tokenConfiguration, (SecurityConfiguration)configuration, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindConfiguration(@Nonnull CompositeConfiguration composite, @Nonnull SecurityConfiguration configuration, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            composite.addConfiguration(configuration, ConfigurationParameters.of(properties));
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindConfiguration(@Nonnull CompositeConfiguration composite, @Nonnull SecurityConfiguration configuration, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            composite.removeConfiguration(configuration);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="authorizableNodeName", service=AuthorizableNodeName.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAuthorizableNodeName(AuthorizableNodeName authorizableNodeName, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableNodeNames.add(authorizableNodeName);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthorizableNodeName(AuthorizableNodeName authorizableNodeName, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableNodeNames.remove(authorizableNodeName);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="authorizableActionProvider", service=AuthorizableActionProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAuthorizableActionProvider(AuthorizableActionProvider authorizableActionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableActionProviders.add(authorizableActionProvider);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthorizableActionProvider(AuthorizableActionProvider authorizableActionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableActionProviders.remove(authorizableActionProvider);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="restrictionProvider", service=RestrictionProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindRestrictionProvider(RestrictionProvider restrictionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.restrictionProviders.add(restrictionProvider);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindRestrictionProvider(RestrictionProvider restrictionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.restrictionProviders.remove(restrictionProvider);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="userAuthenticationFactory", service=UserAuthenticationFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindUserAuthenticationFactory(UserAuthenticationFactory userAuthenticationFactory, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.userAuthenticationFactories.add(userAuthenticationFactory);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindUserAuthenticationFactory(UserAuthenticationFactory userAuthenticationFactory, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.userAuthenticationFactories.remove(userAuthenticationFactory);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRegister() {
        BundleContext context;
        log.info("Trying to register a SecurityProvider...");
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            if (this.context == null) {
                log.info("Aborting: no BundleContext is available");
                return;
            }
            if (!this.preconditions.areSatisfied()) {
                log.info("Aborting: preconditions are not satisfied: {}", (Object)this.preconditions);
                return;
            }
            if (this.registration != null) {
                log.info("Aborting: a SecurityProvider is already registered");
                return;
            }
            if (this.registering) {
                log.info("Aborting: a SecurityProvider is already being registered");
                return;
            }
            this.registering = true;
            context = this.context;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("type", "default");
        ServiceRegistration registration = context.registerService(SecurityProvider.class.getName(), (Object)this.createSecurityProvider(context), properties);
        SecurityProviderRegistration securityProviderRegistration2 = this;
        synchronized (securityProviderRegistration2) {
            this.registration = registration;
            this.registering = false;
        }
        log.info("SecurityProvider instance registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUnregister() {
        ServiceRegistration registration;
        log.info("Trying to unregister the SecurityProvider...");
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            if (this.registration == null) {
                log.info("Aborting: no SecurityProvider is registered");
                return;
            }
            if (this.preconditions.areSatisfied()) {
                log.info("Aborting: preconditions are satisfied");
                return;
            }
            registration = this.registration;
            this.registration = null;
        }
        registration.unregister();
        log.info("SecurityProvider instance unregistered");
    }

    private SecurityProvider createSecurityProvider(@Nonnull BundleContext context) {
        InternalSecurityProvider securityProvider = new InternalSecurityProvider();
        securityProvider.setAuthenticationConfiguration(ConfigurationInitializer.initializeConfiguration(this.authenticationConfiguration, securityProvider, this.rootProvider, this.treeProvider));
        securityProvider.setPrivilegeConfiguration(ConfigurationInitializer.initializeConfiguration(this.privilegeConfiguration, securityProvider, this.rootProvider, this.treeProvider));
        ConfigurationParameters userParams = ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{ConfigurationParameters.of((String)"authorizableActionProvider", (Object)this.createWhiteboardAuthorizableActionProvider()), ConfigurationParameters.of((String)"authorizableNodeName", (Object)this.createWhiteboardAuthorizableNodeName()), ConfigurationParameters.of((String)"userAuthenticationFactory", (Object)this.createWhiteboardUserAuthenticationFactory())});
        securityProvider.setUserConfiguration(ConfigurationInitializer.initializeConfiguration(this.userConfiguration, securityProvider, userParams, this.rootProvider, this.treeProvider));
        ConfigurationParameters restrictionParams = ConfigurationParameters.of((String)"restrictionProvider", (Object)this.createWhiteboardRestrictionProvider());
        ConfigurationInitializer.initializeConfigurations(this.authorizationConfiguration, securityProvider, restrictionParams, this.rootProvider, this.treeProvider);
        securityProvider.setAuthorizationConfiguration(this.authorizationConfiguration);
        ConfigurationInitializer.initializeConfigurations((CompositeConfiguration)this.principalConfiguration, securityProvider, ConfigurationParameters.EMPTY, this.rootProvider, this.treeProvider);
        securityProvider.setPrincipalConfiguration((PrincipalConfiguration)this.principalConfiguration);
        ConfigurationInitializer.initializeConfigurations((CompositeConfiguration)this.tokenConfiguration, securityProvider, ConfigurationParameters.EMPTY, this.rootProvider, this.treeProvider);
        securityProvider.setTokenConfiguration((TokenConfiguration)this.tokenConfiguration);
        securityProvider.setWhiteboard((Whiteboard)new OsgiWhiteboard(context));
        return securityProvider;
    }

    private RestrictionProvider createWhiteboardRestrictionProvider() {
        return new WhiteboardRestrictionProvider(){

            protected List<RestrictionProvider> getServices() {
                return Lists.newArrayList((Iterable)SecurityProviderRegistration.this.restrictionProviders);
            }
        };
    }

    private AuthorizableActionProvider createWhiteboardAuthorizableActionProvider() {
        return new WhiteboardAuthorizableActionProvider(){

            protected List<AuthorizableActionProvider> getServices() {
                return Lists.newArrayList((Iterable)SecurityProviderRegistration.this.authorizableActionProviders);
            }
        };
    }

    private AuthorizableNodeName createWhiteboardAuthorizableNodeName() {
        return new WhiteboardAuthorizableNodeName(){

            protected List<AuthorizableNodeName> getServices() {
                return Lists.newArrayList((Iterable)SecurityProviderRegistration.this.authorizableNodeNames);
            }
        };
    }

    private UserAuthenticationFactory createWhiteboardUserAuthenticationFactory() {
        return new WhiteboardUserAuthenticationFactory(UserConfigurationImpl.getDefaultAuthenticationFactory()){

            protected List<UserAuthenticationFactory> getServices() {
                return Lists.newArrayList((Iterable)SecurityProviderRegistration.this.userAuthenticationFactories);
            }
        };
    }

    private void addCandidate(Map<String, Object> properties) {
        String pidOrName = SecurityProviderRegistration.getServicePidOrComponentName(properties);
        if (pidOrName == null) {
            return;
        }
        this.preconditions.addCandidate(pidOrName);
    }

    private void removeCandidate(Map<String, Object> properties) {
        String pidOrName = SecurityProviderRegistration.getServicePidOrComponentName(properties);
        if (pidOrName == null) {
            return;
        }
        this.preconditions.removeCandidate(pidOrName);
    }

    private static String getServicePidOrComponentName(Map<String, Object> properties) {
        String servicePid = PropertiesUtil.toString((Object)properties.get("service.pid"), null);
        if (servicePid != null) {
            return servicePid;
        }
        return PropertiesUtil.toString((Object)properties.get("oak.security.name"), null);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak SecurityProvider", description="The default SecurityProvider embedded in Apache Jackrabbit Oak")
    static @interface Configuration {
        @AttributeDefinition(name="Required Services", description="The SecurityProvider will not register itself unless the services identified by the following service pids or the oak.security.name properties are registered first. The class name is identified by checking the service.pid property. If that property does not exist, the oak.security.name property is used as a fallback.Only implementations of the following interfaces are checked :AuthorizationConfiguration, PrincipalConfiguration, TokenConfiguration, AuthorizableActionProvider, RestrictionProvider and UserAuthenticationFactory.")
        public String[] requiredServicePids() default {"org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl", "org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl", "org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl", "org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider", "org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl", "org.apache.jackrabbit.oak.security.user.UserAuthenticationFactoryImpl"};

        @AttributeDefinition(name="Authorization Composition Type", description="The Composite Authorization model uses this flag to determine what type of logic to apply to the existing providers (default value is AND).", options={@Option(label="AND", value="AND"), @Option(label="OR", value="OR")})
        public String authorizationCompositionType() default "AND";
    }
}

