/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;

final class ConfigurationInitializer {
    private ConfigurationInitializer() {
    }

    @Nonnull
    static <T extends SecurityConfiguration> T initializeConfiguration(@Nonnull T configuration, @Nonnull SecurityProvider securityProvider, @Nonnull RootProvider rootProvider, @Nonnull TreeProvider treeProvider) {
        return ConfigurationInitializer.initializeConfiguration(configuration, securityProvider, ConfigurationParameters.EMPTY, rootProvider, treeProvider);
    }

    @Nonnull
    static <T extends SecurityConfiguration> T initializeConfiguration(@Nonnull T configuration, @Nonnull SecurityProvider securityProvider, @Nonnull ConfigurationParameters parameters, @Nonnull RootProvider rootProvider, @Nonnull TreeProvider treeProvider) {
        if (configuration instanceof ConfigurationBase) {
            ConfigurationBase base = (ConfigurationBase)configuration;
            base.setSecurityProvider(securityProvider);
            base.setRootProvider(rootProvider);
            base.setTreeProvider(treeProvider);
            base.setParameters(ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{base.getParameters(), parameters}));
        }
        return configuration;
    }

    static void initializeConfigurations(@Nonnull CompositeConfiguration configuration, @Nonnull SecurityProvider securityProvider, @Nonnull ConfigurationParameters parameters, @Nonnull RootProvider rootProvider, @Nonnull TreeProvider treeProvider) {
        configuration.setSecurityProvider(securityProvider);
        configuration.setRootProvider(rootProvider);
        configuration.setTreeProvider(treeProvider);
        List configs = configuration.getConfigurations();
        for (SecurityConfiguration config : configs) {
            ConfigurationInitializer.initializeConfiguration(config, securityProvider, parameters, rootProvider, treeProvider);
        }
    }
}

