/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;

class VersionTreePermission
implements TreePermission,
VersionConstants {
    private static final Set<String> NT_NAMES = ImmutableSet.of((Object)"nt:version", (Object)"nt:versionLabels");
    private final Tree versionTree;
    private final TreePermission versionablePermission;

    VersionTreePermission(@Nonnull Tree versionTree, @Nonnull TreePermission versionablePermission) {
        this.versionTree = versionTree;
        this.versionablePermission = versionablePermission;
    }

    VersionTreePermission createChildPermission(@Nonnull Tree versionTree) {
        TreePermission delegatee = "jcr:frozenNode".equals(versionTree.getName()) || NT_NAMES.contains(TreeUtil.getPrimaryTypeName((Tree)versionTree)) ? this.versionablePermission : this.versionablePermission.getChildPermission(versionTree.getName(), ((ImmutableTree)versionTree).getNodeState());
        return new VersionTreePermission(versionTree, delegatee);
    }

    @Nonnull
    public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
        return this.createChildPermission(new ImmutableTree((ImmutableTree)this.versionTree, childName, childState));
    }

    public boolean canRead() {
        return this.versionablePermission.canRead();
    }

    public boolean canRead(@Nonnull PropertyState property) {
        return this.versionablePermission.canRead(property);
    }

    public boolean canReadAll() {
        return this.versionablePermission.canReadAll();
    }

    public boolean canReadProperties() {
        return this.versionablePermission.canReadProperties();
    }

    public boolean isGranted(long permissions) {
        return this.versionablePermission.isGranted(permissions);
    }

    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return this.versionablePermission.isGranted(permissions, property);
    }
}

