/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.MoveAwarePermissionValidator;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class PermissionValidatorProvider
extends ValidatorProvider {
    private final SecurityProvider securityProvider;
    private final AuthorizationConfiguration acConfig;
    private final long jr2Permissions;
    private final String workspaceName;
    private final Set<Principal> principals;
    private final MoveTracker moveTracker;
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;
    private Context acCtx;
    private Context userCtx;

    public PermissionValidatorProvider(@Nonnull SecurityProvider securityProvider, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker, @Nonnull RootProvider rootProvider, @Nonnull TreeProvider treeProvider) {
        this.securityProvider = securityProvider;
        this.acConfig = (AuthorizationConfiguration)securityProvider.getConfiguration(AuthorizationConfiguration.class);
        ConfigurationParameters params = this.acConfig.getParameters();
        String compatValue = (String)params.getConfigValue("permissionsJr2", null, String.class);
        this.jr2Permissions = Permissions.getPermissions((String)compatValue);
        this.workspaceName = workspaceName;
        this.principals = principals;
        this.moveTracker = moveTracker;
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
    }

    @Nonnull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        PermissionProvider pp = this.acConfig.getPermissionProvider(this.createReadOnlyRoot(before), this.workspaceName, this.principals);
        if (this.moveTracker.isEmpty()) {
            return new PermissionValidator(before, after, pp, this);
        }
        return new MoveAwarePermissionValidator(before, after, pp, this, this.moveTracker);
    }

    Context getAccessControlContext() {
        if (this.acCtx == null) {
            this.acCtx = this.acConfig.getContext();
        }
        return this.acCtx;
    }

    Context getUserContext() {
        if (this.userCtx == null) {
            UserConfiguration uc = (UserConfiguration)this.securityProvider.getConfiguration(UserConfiguration.class);
            this.userCtx = uc.getContext();
        }
        return this.userCtx;
    }

    boolean requiresJr2Permissions(long permission) {
        return Permissions.includes((long)this.jr2Permissions, (long)permission);
    }

    Root createReadOnlyRoot(@Nonnull NodeState nodeState) {
        return this.rootProvider.createReadOnlyRoot(nodeState);
    }

    Tree createReadOnlyTree(@Nonnull NodeState nodeState) {
        return this.treeProvider.createReadOnlyTree(nodeState);
    }
}

