/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PermissionStoreImpl
implements PermissionStore,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(PermissionStoreImpl.class);
    private final String permissionRootName;
    private final RestrictionProvider restrictionProvider;
    private final Map<String, Tree> principalTreeMap = new HashMap<String, Tree>();
    private Tree permissionsTree;
    private PrivilegeBits allBits;

    PermissionStoreImpl(Root root, String permissionRootName, RestrictionProvider restrictionProvider) {
        this.permissionRootName = permissionRootName;
        this.restrictionProvider = restrictionProvider;
        this.reset(root);
    }

    @Override
    public void flush(@Nonnull Root root) {
        this.principalTreeMap.clear();
        this.reset(root);
    }

    private void reset(@Nonnull Root root) {
        this.permissionsTree = PermissionUtil.getPermissionsRoot(root, this.permissionRootName);
        this.allBits = new PrivilegeBitsProvider(root).getBits(new String[]{"jcr:all"});
    }

    @Override
    @CheckForNull
    public Collection<PermissionEntry> load(@Nullable Collection<PermissionEntry> entries, @Nonnull String principalName, @Nonnull String path) {
        String name;
        Tree principalRoot = this.getPrincipalRoot(principalName);
        if (principalRoot != null && principalRoot.hasChild(name = PermissionUtil.getEntryName(path))) {
            Tree child = principalRoot.getChild(name);
            if (PermissionUtil.checkACLPath(child, path)) {
                entries = this.loadPermissionEntries(path, entries, child);
            } else {
                for (Tree node : child.getChildren()) {
                    if (!PermissionUtil.checkACLPath(node, path)) continue;
                    entries = this.loadPermissionEntries(path, entries, node);
                }
            }
        }
        return entries == null || entries.isEmpty() ? null : entries;
    }

    @Override
    public long getNumEntries(@Nonnull String principalName, long max) {
        Tree tree = this.getPrincipalRoot(principalName);
        return tree == null ? 0L : tree.getChildrenCount(max);
    }

    @Override
    @Nonnull
    public PrincipalPermissionEntries load(@Nonnull String principalName) {
        long t0 = System.nanoTime();
        PrincipalPermissionEntries ret = new PrincipalPermissionEntries();
        Tree principalRoot = this.getPrincipalRoot(principalName);
        if (principalRoot != null) {
            for (Tree entryTree : principalRoot.getChildren()) {
                this.loadPermissionEntries(entryTree, ret.getEntries());
            }
        }
        ret.setFullyLoaded(true);
        long t1 = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug(String.format("loaded %d entries in %.2fus for %s.%n", ret.getSize(), (double)(t1 - t0) / 1000.0, principalName));
        }
        return ret;
    }

    @CheckForNull
    private Tree getPrincipalRoot(@Nonnull String principalName) {
        if (this.principalTreeMap.containsKey(principalName)) {
            return this.principalTreeMap.get(principalName);
        }
        Tree principalRoot = PermissionUtil.getPrincipalRoot(this.permissionsTree, principalName);
        if (!principalRoot.exists()) {
            principalRoot = null;
        }
        this.principalTreeMap.put(principalName, principalRoot);
        return principalRoot;
    }

    private void loadPermissionEntries(@Nonnull Tree tree, @Nonnull Map<String, Collection<PermissionEntry>> pathEntryMap) {
        String path = TreeUtil.getString((Tree)tree, (String)"rep:accessControlledPath");
        if (path != null) {
            Collection<PermissionEntry> entries = pathEntryMap.get(path);
            if (entries == null) {
                entries = new TreeSet<PermissionEntry>();
                pathEntryMap.put(path, entries);
            }
            for (Tree child : tree.getChildren()) {
                if (child.getName().charAt(0) == 'c') {
                    this.loadPermissionEntries(child, pathEntryMap);
                    continue;
                }
                entries.add(this.createPermissionEntry(path, child));
            }
        } else {
            log.error("Permission entry at '{}' without rep:accessControlledPath property.", (Object)tree.getPath());
        }
    }

    @CheckForNull
    private Collection<PermissionEntry> loadPermissionEntries(@Nonnull String path, @Nullable Collection<PermissionEntry> ret, @Nonnull Tree tree) {
        for (Tree ace : tree.getChildren()) {
            if (ace.getName().charAt(0) == 'c') continue;
            if (ret == null) {
                ret = new TreeSet<PermissionEntry>();
            }
            ret.add(this.createPermissionEntry(path, ace));
        }
        return ret;
    }

    @Nonnull
    private PermissionEntry createPermissionEntry(@Nonnull String path, @Nonnull Tree entryTree) {
        PropertyState ps = entryTree.getProperty("rep:privileges");
        PrivilegeBits bits = PermissionStoreImpl.isJcrAll(ps) ? this.allBits : PrivilegeBits.getInstance((PropertyState)ps);
        boolean isAllow = TreeUtil.getBoolean((Tree)entryTree, (String)"rep:isAllow");
        return new PermissionEntry(path, isAllow, Integer.parseInt(entryTree.getName()), bits, this.restrictionProvider.getPattern(path, entryTree));
    }

    private static boolean isJcrAll(@CheckForNull PropertyState property) {
        return property != null && property.count() == 1 && (Long)property.getValue(Type.LONG, 0) == -1L;
    }
}

