/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidator;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class MoveAwarePermissionValidator
extends PermissionValidator {
    private final MoveContext moveCtx;

    MoveAwarePermissionValidator(@Nonnull NodeState rootBefore, @Nonnull NodeState rootAfter, @Nonnull PermissionProvider permissionProvider, @Nonnull PermissionValidatorProvider provider, @Nonnull MoveTracker moveTracker) {
        super(rootBefore, rootAfter, permissionProvider, provider);
        this.moveCtx = new MoveContext(moveTracker, provider.createReadOnlyRoot(rootBefore), provider.createReadOnlyRoot(rootAfter));
    }

    private MoveAwarePermissionValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @Nonnull TreePermission parentPermission, @Nonnull PermissionValidator parentValidator) {
        super(parentBefore, parentAfter, parentPermission, parentValidator);
        MoveAwarePermissionValidator pv = (MoveAwarePermissionValidator)parentValidator;
        this.moveCtx = pv.moveCtx;
    }

    @Override
    @Nonnull
    PermissionValidator createValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @Nonnull TreePermission parentPermission, @Nonnull PermissionValidator parentValidator) {
        if (this.moveCtx.containsMove(parentBefore, parentAfter)) {
            return new MoveAwarePermissionValidator(parentBefore, parentAfter, parentPermission, parentValidator);
        }
        return super.createValidator(parentBefore, parentAfter, parentPermission, parentValidator);
    }

    private Validator visibleValidator(@Nonnull Tree source, @Nonnull Tree dest) {
        ImmutableTree immutableTree = (ImmutableTree)this.moveCtx.rootBefore.getTree("/");
        TreePermission tp = this.getPermissionProvider().getTreePermission((Tree)immutableTree, TreePermission.EMPTY);
        for (String n : PathUtils.elements((String)source.getPath())) {
            immutableTree = immutableTree.getChild(n);
            tp = tp.getChildPermission(n, immutableTree.getNodeState());
        }
        PermissionValidator validator = this.createValidator(source, dest, tp, this);
        return new VisibleValidator((Validator)validator, true, false);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (this.moveCtx.processAdd(this.getParentAfter(), name, this)) {
            return null;
        }
        return super.childNodeAdded(name, after);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.moveCtx.processDelete(this.getParentBefore(), name, this)) {
            return null;
        }
        return super.childNodeDeleted(name, before);
    }

    private final class MoveContext {
        private final MoveTracker moveTracker;
        private final Root rootBefore;
        private final Root rootAfter;

        private MoveContext(@Nonnull MoveTracker moveTracker, @Nonnull Root before, Root after) {
            this.moveTracker = moveTracker;
            this.rootBefore = before;
            this.rootAfter = after;
        }

        private boolean containsMove(@Nullable Tree parentBefore, @Nullable Tree parentAfter) {
            return this.moveTracker.containsMove(PermissionUtil.getPath(parentBefore, parentAfter));
        }

        private boolean processAdd(@CheckForNull Tree parent, @Nonnull String name, @Nonnull MoveAwarePermissionValidator validator) throws CommitFailedException {
            ImmutableTree source;
            if (parent == null) {
                return false;
            }
            ImmutableTree child = (ImmutableTree)parent.getChild(name);
            String sourcePath = this.moveTracker.getSourcePath(child.getPath());
            if (sourcePath != null && (source = (ImmutableTree)this.rootBefore.getTree(sourcePath)).exists()) {
                validator.checkPermissions(child, false, 544L);
                this.checkPermissions(source, 64L);
                return this.diff(source, child, validator);
            }
            return false;
        }

        private boolean processDelete(@CheckForNull Tree parent, @Nonnull String name, @Nonnull MoveAwarePermissionValidator validator) throws CommitFailedException {
            ImmutableTree dest;
            if (parent == null) {
                return false;
            }
            ImmutableTree child = (ImmutableTree)parent.getChild(name);
            String destPath = this.moveTracker.getDestPath(child.getPath());
            if (destPath != null && (dest = (ImmutableTree)this.rootAfter.getTree(destPath)).exists()) {
                validator.checkPermissions(child, true, 64L);
                this.checkPermissions(dest, 544L);
                return this.diff(child, dest, validator);
            }
            return false;
        }

        private boolean diff(@Nonnull ImmutableTree source, @Nonnull ImmutableTree dest, @Nonnull MoveAwarePermissionValidator validator) throws CommitFailedException {
            Validator nextValidator = validator.visibleValidator(source, dest);
            CommitFailedException e = EditorDiff.process((Editor)nextValidator, (NodeState)source.getNodeState(), (NodeState)dest.getNodeState());
            if (e != null) {
                throw e;
            }
            return true;
        }

        private void checkPermissions(@Nonnull Tree tree, long permissions) throws CommitFailedException {
            if (!MoveAwarePermissionValidator.this.getPermissionProvider().isGranted(tree, null, permissions)) {
                throw new CommitFailedException("Access", 0, "Access denied");
            }
        }
    }
}

