/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenAuthentication;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.TokenProviderCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(TokenLoginModule.class);
    private TokenProvider tokenProvider;
    private TokenCredentials tokenCredentials;
    private TokenInfo tokenInfo;
    private String userId;
    private Principal principal;

    public boolean login() throws LoginException {
        TokenCredentials tc;
        TokenAuthentication authentication;
        this.tokenProvider = this.getTokenProvider();
        if (this.tokenProvider == null) {
            return false;
        }
        Credentials credentials = this.getCredentials();
        if (credentials instanceof TokenCredentials && (authentication = new TokenAuthentication(this.tokenProvider)).authenticate((Credentials)(tc = (TokenCredentials)credentials))) {
            this.tokenCredentials = tc;
            this.tokenInfo = authentication.getTokenInfo();
            this.userId = authentication.getUserId();
            this.principal = authentication.getUserPrincipal();
            log.debug("Login: adding login name to shared state.");
            this.sharedState.put("javax.security.auth.login.name", this.userId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() throws LoginException {
        block8: {
            if (this.tokenCredentials != null && this.userId != null) {
                Set principals = this.principal != null ? this.getPrincipals(this.principal) : this.getPrincipals(this.userId);
                this.updateSubject(this.tokenCredentials, this.getAuthInfo(this.tokenInfo, principals), principals);
                return true;
            }
            try {
                TokenInfo ti;
                Credentials shared;
                if (this.tokenProvider == null || !this.sharedState.containsKey("org.apache.jackrabbit.credentials") || (shared = this.getSharedCredentials()) == null || !this.tokenProvider.doCreateToken(shared)) break block8;
                Root r = this.getRoot();
                if (r != null) {
                    r.refresh();
                }
                if ((ti = this.tokenProvider.createToken(shared)) != null) {
                    TokenCredentials tc = new TokenCredentials(ti.getToken());
                    Map attributes = ti.getPrivateAttributes();
                    for (String name : attributes.keySet()) {
                        tc.setAttribute(name, (String)attributes.get(name));
                    }
                    attributes = ti.getPublicAttributes();
                    for (String name : attributes.keySet()) {
                        tc.setAttribute(name, (String)attributes.get(name));
                    }
                    this.sharedState.put("javax.security.auth.login.attributes", attributes);
                    this.updateSubject(tc, null, null);
                    break block8;
                }
                String logId = this.userId != null ? this.userId : this.sharedState.get("javax.security.auth.login.name");
                log.debug("TokenProvider failed to create a login token for user " + logId);
                throw new LoginException("Failed to create login token for user " + logId);
            }
            finally {
                this.clearState();
            }
        }
        return false;
    }

    @Nonnull
    protected Set<Class> getSupportedCredentials() {
        return Collections.singleton(TokenCredentials.class);
    }

    protected void clearState() {
        super.clearState();
        this.tokenCredentials = null;
        this.tokenInfo = null;
        this.userId = null;
    }

    @CheckForNull
    private TokenProvider getTokenProvider() {
        TokenProvider provider = null;
        SecurityProvider securityProvider = this.getSecurityProvider();
        Root root = this.getRoot();
        if (root != null && securityProvider != null) {
            TokenConfiguration tokenConfig = (TokenConfiguration)securityProvider.getConfiguration(TokenConfiguration.class);
            provider = tokenConfig.getTokenProvider(root);
        }
        if (provider == null && this.callbackHandler != null) {
            try {
                TokenProviderCallback tcCallback = new TokenProviderCallback();
                this.callbackHandler.handle(new Callback[]{tcCallback});
                provider = tcCallback.getTokenProvider();
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                log.warn(e.getMessage());
            }
        }
        return provider;
    }

    @CheckForNull
    private AuthInfo getAuthInfo(@Nullable TokenInfo tokenInfo, @Nonnull Set<? extends Principal> principals) {
        if (tokenInfo != null) {
            HashMap attributes = new HashMap();
            Map publicAttributes = tokenInfo.getPublicAttributes();
            for (String attrName : publicAttributes.keySet()) {
                attributes.put(attrName, publicAttributes.get(attrName));
            }
            return new AuthInfoImpl(tokenInfo.getUserId(), attributes, principals);
        }
        return null;
    }

    private void updateSubject(@Nonnull TokenCredentials tc, @Nullable AuthInfo authInfo, @Nullable Set<? extends Principal> principals) {
        if (!this.subject.isReadOnly()) {
            this.subject.getPublicCredentials().add(tc);
            if (principals != null) {
                this.subject.getPrincipals().addAll(principals);
            }
            if (authInfo != null) {
                TokenLoginModule.setAuthInfo((AuthInfo)authInfo, (Subject)this.subject);
            }
        }
    }
}

