/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Locale;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;

public class LiteralImpl
extends StaticOperandImpl {
    private final PropertyValue value;
    private int hashCode;

    public LiteralImpl(PropertyValue value) {
        this.value = value;
    }

    public PropertyValue getLiteralValue() {
        return this.value;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    private String escape() {
        return SQL2Parser.escapeStringLiteral((String)this.value.getValue(Type.STRING));
    }

    @Override
    public PropertyValue currentValue() {
        return this.value;
    }

    @Override
    int getPropertyType() {
        PropertyValue v = this.currentValue();
        return v == null ? 0 : v.getType().tag();
    }

    public String toString() {
        if (this.value.getType() == Type.STRING) {
            return this.escape();
        }
        if (this.value.getType() == Type.LONG) {
            return Long.toString((Long)this.value.getValue(Type.LONG));
        }
        String type = PropertyType.nameFromValue((int)this.value.getType().tag());
        return "cast(" + this.escape() + " as " + type.toLowerCase(Locale.ENGLISH) + ')';
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof LiteralImpl) {
            return this.value.equals(((LiteralImpl)that).value);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.value.hashCode();
        }
        return this.hashCode;
    }
}

