/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class DescendantNodeJoinConditionImpl
extends JoinConditionImpl {
    private final String descendantSelectorName;
    private final String ancestorSelectorName;
    private SelectorImpl descendantSelector;
    private SelectorImpl ancestorSelector;

    public DescendantNodeJoinConditionImpl(String descendantSelectorName, String ancestorSelectorName) {
        this.descendantSelectorName = descendantSelectorName;
        this.ancestorSelectorName = ancestorSelectorName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "isdescendantnode(" + this.quote(this.descendantSelectorName) + ", " + this.quote(this.ancestorSelectorName) + ')';
    }

    public void bindSelector(SourceImpl source) {
        this.descendantSelector = source.getExistingSelector(this.descendantSelectorName);
        this.ancestorSelector = source.getExistingSelector(this.ancestorSelectorName);
    }

    @Override
    public boolean evaluate() {
        String a = this.ancestorSelector.currentPath();
        String d = this.descendantSelector.currentPath();
        return PathUtils.isAncestor((String)a, (String)d);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.ancestorSelector)) {
            // empty if block
        }
        if (f.getSelector().equals(this.descendantSelector)) {
            String a = this.ancestorSelector.currentPath();
            if (a == null && f.isPreparing() && f.isPrepared(this.ancestorSelector)) {
                f.restrictPath("//path/from/join", Filter.PathRestriction.ALL_CHILDREN);
            } else if (a != null) {
                f.restrictPath(a, Filter.PathRestriction.ALL_CHILDREN);
            }
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
    }

    @Override
    public boolean isParent(SourceImpl source) {
        return source.equals(this.ancestorSelector);
    }

    @Override
    public boolean canEvaluate(Set<SourceImpl> available) {
        return available.contains(this.descendantSelector) && available.contains(this.ancestorSelector);
    }

    @Override
    public AstElement copyOf() {
        return new DescendantNodeJoinConditionImpl(this.descendantSelectorName, this.ancestorSelectorName);
    }
}

