/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBean;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBeanImpl;
import org.apache.jackrabbit.oak.query.stats.QueryStatsReporter;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;

public class QueryEngineSettings
implements QueryEngineSettingsMBean,
QueryLimits {
    public static final String SQL2_OPTIMISATION_FLAG = "oak.query.sql2optimisation";
    public static final String SQL2_OPTIMISATION_FLAG_2 = "oak.query.sql2optimisation2";
    public static final boolean SQL2_OPTIMIZATION_2 = Boolean.parseBoolean(System.getProperty("oak.query.sql2optimisation2", "true"));
    public static final String OAK_QUERY_LIMIT_IN_MEMORY = "oak.queryLimitInMemory";
    public static final int DEFAULT_QUERY_LIMIT_IN_MEMORY = Integer.getInteger("oak.queryLimitInMemory", 500000);
    public static final String OAK_QUERY_LIMIT_READS = "oak.queryLimitReads";
    public static final int DEFAULT_QUERY_LIMIT_READS = Integer.getInteger("oak.queryLimitReads", 100000);
    public static final String OAK_QUERY_FAIL_TRAVERSAL = "oak.queryFailTraversal";
    private static final boolean DEFAULT_FAIL_TRAVERSAL = Boolean.getBoolean("oak.queryFailTraversal");
    private static final boolean DEFAULT_FULL_TEXT_COMPARISON_WITHOUT_INDEX = Boolean.getBoolean("oak.queryFullTextComparisonWithoutIndex");
    private long limitInMemory = DEFAULT_QUERY_LIMIT_IN_MEMORY;
    private long limitReads = DEFAULT_QUERY_LIMIT_READS;
    private boolean failTraversal = DEFAULT_FAIL_TRAVERSAL;
    private boolean fullTextComparisonWithoutIndex = DEFAULT_FULL_TEXT_COMPARISON_WITHOUT_INDEX;
    private boolean sql2Optimisation = Boolean.parseBoolean(System.getProperty("oak.query.sql2optimisation", "true"));
    private static final String OAK_FAST_QUERY_SIZE = "oak.fastQuerySize";
    public static final boolean DEFAULT_FAST_QUERY_SIZE = Boolean.getBoolean("oak.fastQuerySize");
    private boolean fastQuerySize = DEFAULT_FAST_QUERY_SIZE;
    private QueryStatsMBeanImpl queryStats = new QueryStatsMBeanImpl(this);

    public long getLimitInMemory() {
        return this.limitInMemory;
    }

    public void setLimitInMemory(long limitInMemory) {
        this.limitInMemory = limitInMemory;
    }

    public long getLimitReads() {
        return this.limitReads;
    }

    public void setLimitReads(long limitReads) {
        this.limitReads = limitReads;
    }

    public boolean getFailTraversal() {
        return this.failTraversal;
    }

    public void setFailTraversal(boolean failTraversal) {
        this.failTraversal = failTraversal;
    }

    public boolean isFastQuerySize() {
        return this.fastQuerySize;
    }

    public void setFastQuerySize(boolean fastQuerySize) {
        this.fastQuerySize = fastQuerySize;
        System.setProperty(OAK_FAST_QUERY_SIZE, String.valueOf(fastQuerySize));
    }

    public void setFullTextComparisonWithoutIndex(boolean fullTextComparisonWithoutIndex) {
        this.fullTextComparisonWithoutIndex = fullTextComparisonWithoutIndex;
    }

    public boolean getFullTextComparisonWithoutIndex() {
        return this.fullTextComparisonWithoutIndex;
    }

    public boolean isSql2Optimisation() {
        return this.sql2Optimisation;
    }

    public QueryStatsMBean getQueryStats() {
        return this.queryStats;
    }

    public QueryStatsReporter getQueryStatsReporter() {
        return this.queryStats;
    }

    public String toString() {
        return "QueryEngineSettings{limitInMemory=" + this.limitInMemory + ", limitReads=" + this.limitReads + ", failTraversal=" + this.failTraversal + ", fullTextComparisonWithoutIndex=" + this.fullTextComparisonWithoutIndex + ", sql2Optimisation=" + this.sql2Optimisation + ", fastQuerySize=" + this.fastQuerySize + '}';
    }
}

