/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfo;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateNodeTypeInfoProvider
implements NodeTypeInfoProvider {
    private final NodeState types;

    public NodeStateNodeTypeInfoProvider(NodeState baseState) {
        this.types = baseState.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
    }

    @Override
    public NodeTypeInfo getNodeTypeInfo(String nodeTypeName) {
        NodeState type = this.types.getChildNode(nodeTypeName);
        return new NodeStateNodeTypeInfo(type);
    }

    static class NodeStateNodeTypeInfo
    implements NodeTypeInfo {
        private final NodeState type;

        NodeStateNodeTypeInfo(NodeState type) {
            this.type = type;
        }

        @Override
        public boolean exists() {
            return this.type.exists();
        }

        @Override
        public String getNodeTypeName() {
            return this.type.getName("jcr:nodeTypeName");
        }

        @Override
        public Set<String> getSuperTypes() {
            return Sets.newHashSet((Iterable)this.type.getNames("rep:supertypes"));
        }

        @Override
        public Set<String> getPrimarySubTypes() {
            return Sets.newHashSet((Iterable)this.type.getNames("rep:primarySubtypes"));
        }

        @Override
        public Set<String> getMixinSubTypes() {
            return Sets.newHashSet((Iterable)this.type.getNames("rep:mixinSubtypes"));
        }

        @Override
        public boolean isMixin() {
            return this.type.getBoolean("jcr:isMixin");
        }

        @Override
        public Iterable<String> getNamesSingleValuesProperties() {
            return this.type.getNames("rep:namedSingleValuedProperties");
        }
    }
}

