/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;

abstract class AbstractTypeDefinition {
    private static final String[] NO_STRINGS = new String[0];
    protected final Tree definition;
    protected final NamePathMapper mapper;

    protected AbstractTypeDefinition(Tree definition, NamePathMapper mapper) {
        this.definition = (Tree)Preconditions.checkNotNull((Object)definition);
        this.mapper = (NamePathMapper)Preconditions.checkNotNull((Object)mapper);
    }

    protected boolean getBoolean(@Nonnull String name) {
        PropertyState property = this.definition.getProperty((String)Preconditions.checkNotNull((Object)name));
        return property != null && (Boolean)property.getValue(Type.BOOLEAN) != false;
    }

    @CheckForNull
    protected String getString(@Nonnull String oakName) {
        return this.getValue(oakName, (Type<String>)Type.STRING);
    }

    @CheckForNull
    protected String[] getStrings(@Nonnull String oakName) {
        return this.getValues(oakName, (Type<String>)Type.STRING);
    }

    @CheckForNull
    protected String getName(@Nonnull String oakName) {
        return this.getValue(oakName, (Type<String>)Type.NAME);
    }

    @CheckForNull
    protected String[] getNames(@Nonnull String oakName) {
        return this.getValues(oakName, (Type<String>)Type.NAME);
    }

    private String getValue(String oakName, Type<String> type) {
        PropertyState property = this.definition.getProperty((String)Preconditions.checkNotNull((Object)oakName));
        if (property != null) {
            return (String)property.getValue(type);
        }
        return null;
    }

    private String[] getValues(String oakName, Type<String> type) {
        String[] values = null;
        PropertyState property = this.definition.getProperty((String)Preconditions.checkNotNull((Object)oakName));
        if (property != null) {
            int n = property.count();
            if (n > 0) {
                values = new String[n];
                for (int i = 0; i < n; ++i) {
                    values[i] = (String)property.getValue(type, i);
                }
            } else {
                values = NO_STRINGS;
            }
        }
        return values;
    }
}

