/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.itemsave;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.FailingValidator;
import org.apache.jackrabbit.oak.spi.commit.SubtreeExcludingValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;

class ItemSaveValidator
extends SubtreeExcludingValidator {
    private final String ignorePropertyChange;

    public ItemSaveValidator(String path) {
        this((Validator)new FailingValidator("Unsupported", 0, "Failed to save subtree at " + path + ". There are transient modifications outside that subtree."), Lists.newArrayList((Iterable)PathUtils.elements((String)path)));
    }

    private ItemSaveValidator(Validator validator, List<String> path) {
        super(validator, path);
        this.ignorePropertyChange = path.size() == 1 ? path.get(0) : null;
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (!before.getName().equals(this.ignorePropertyChange)) {
            super.propertyChanged(before, after);
        }
    }

    protected SubtreeExcludingValidator createValidator(Validator validator, List<String> path) {
        return new ItemSaveValidator(validator, path);
    }
}

