/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.strategy;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.counter.ApproximateCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMirrorStoreStrategy
implements IndexStoreStrategy {
    static final Logger LOG = LoggerFactory.getLogger(ContentMirrorStoreStrategy.class);
    public static final int TRAVERSING_WARN = Integer.getInteger("oak.traversing.warn", 10000);
    private final String indexName;
    private final String pathPrefix;
    private final boolean prependPathPrefix;

    public ContentMirrorStoreStrategy() {
        this(":index");
    }

    public ContentMirrorStoreStrategy(String indexName) {
        this(indexName, "", true);
    }

    public ContentMirrorStoreStrategy(String indexName, String pathPrefix, boolean prependPathPrefix) {
        this.indexName = indexName;
        this.pathPrefix = pathPrefix;
        this.prependPathPrefix = prependPathPrefix;
    }

    @Override
    public void update(Supplier<NodeBuilder> index, String path, @Nullable String indexName, @Nullable NodeBuilder indexMeta, Set<String> beforeKeys, Set<String> afterKeys) {
        for (String key : beforeKeys) {
            this.remove((NodeBuilder)index.get(), key, path);
        }
        for (String key : afterKeys) {
            this.insert((NodeBuilder)index.get(), key, path);
        }
    }

    private void remove(NodeBuilder index, String key, String value) {
        ApproximateCounter.adjustCountSync(index, -1L);
        NodeBuilder builder = index.getChildNode(key);
        if (builder.exists()) {
            ApproximateCounter.adjustCountSync(builder, -1L);
            ArrayDeque builders = Queues.newArrayDeque();
            builders.addFirst(builder);
            for (String name : PathUtils.elements((String)value)) {
                builder = builder.getChildNode(name);
                builders.addFirst(builder);
            }
            if (builder.exists()) {
                builder.removeProperty("match");
            }
            this.prune(index, builders, key);
        }
    }

    private void insert(NodeBuilder index, String key, String value) {
        ApproximateCounter.adjustCountSync(index, 1L);
        NodeBuilder builder = this.fetchKeyNode(index, key);
        ApproximateCounter.adjustCountSync(builder, 1L);
        for (String name : PathUtils.elements((String)value)) {
            builder = builder.child(name);
        }
        builder.setProperty("match", (Object)true);
    }

    public Iterable<String> query(final Filter filter, final String indexName, NodeState indexMeta, String indexStorageNodeName, final Iterable<String> values) {
        final NodeState index = indexMeta.getChildNode(indexStorageNodeName);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                PathIterator it = new PathIterator(filter, indexName, ContentMirrorStoreStrategy.this.pathPrefix, ContentMirrorStoreStrategy.this.prependPathPrefix);
                if (values == null) {
                    it.setPathContainsValue(true);
                    it.enqueue(ContentMirrorStoreStrategy.this.getChildNodeEntries(index).iterator());
                } else {
                    for (String p : values) {
                        NodeState property = index.getChildNode(p);
                        if (!property.exists()) continue;
                        it.enqueue((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry("", property)));
                    }
                }
                return it;
            }
        };
    }

    @Nonnull
    Iterable<? extends ChildNodeEntry> getChildNodeEntries(@Nonnull NodeState index) {
        return index.getChildNodeEntries();
    }

    @Override
    public Iterable<String> query(Filter filter, String name, NodeState indexMeta, Iterable<String> values) {
        return this.query(filter, name, indexMeta, this.indexName, values);
    }

    @Override
    public long count(NodeState root, NodeState indexMeta, Set<String> values, int max) {
        return this.count(null, root, indexMeta, this.indexName, values, max);
    }

    @Override
    public long count(Filter filter, NodeState root, NodeState indexMeta, Set<String> values, int max) {
        return this.count(filter, root, indexMeta, this.indexName, values, max);
    }

    long count(Filter filter, NodeState root, NodeState indexMeta, String indexStorageNodeName, Set<String> values, int max) {
        long filterPathCount;
        long totalNodesCount;
        long count;
        block16: {
            NodeState index;
            block15: {
                index = indexMeta.getChildNode(indexStorageNodeName);
                count = -1L;
                if (values != null) break block15;
                PropertyState ec = indexMeta.getProperty("entryCount");
                count = ec != null ? (Long)ec.getValue(Type.LONG) : ApproximateCounter.getCountSync(index);
                if (count >= 0L) break block16;
                CountingNodeVisitor v = new CountingNodeVisitor(max);
                v.visit(index);
                count = v.getEstimatedCount();
                if (count < (long)max) break block16;
                count *= 10L;
                break block16;
            }
            int size = values.size();
            if (size == 0) {
                return 0L;
            }
            PropertyState ec = indexMeta.getProperty("entryCount");
            if (ec != null) {
                count = (Long)ec.getValue(Type.LONG);
                if (count >= 0L) {
                    long keyCount = count / 10000L;
                    ec = indexMeta.getProperty("keyCount");
                    if (ec != null) {
                        keyCount = (Long)ec.getValue(Type.LONG);
                    }
                    keyCount = Math.max(1L, keyCount);
                    count = (long)((double)count / (double)keyCount) + (long)size;
                }
            } else {
                long approxMax = 0L;
                long approxCount = ApproximateCounter.getCountSync(index);
                if (approxCount != -1L) {
                    for (String p : values) {
                        NodeState s = index.getChildNode(p);
                        if (!s.exists()) continue;
                        long a = ApproximateCounter.getCountSync(s);
                        if (a != -1L) {
                            approxMax += a;
                            continue;
                        }
                        if (approxMax <= 0L) continue;
                        approxMax += 10000L;
                    }
                    if (approxMax > 0L) {
                        count = approxMax;
                    }
                }
            }
            if (count < 0L) {
                count = 0L;
                max = Math.max(10, max / size);
                int i = 0;
                for (String p : values) {
                    if (count > (long)max && i > 3) {
                        count = count * (long)size / (long)i;
                        break;
                    }
                    NodeState s = index.getChildNode(p);
                    if (s.exists()) {
                        CountingNodeVisitor v = new CountingNodeVisitor(max);
                        v.visit(s);
                        count += (long)v.getEstimatedCount();
                    }
                    ++i;
                }
            }
        }
        String filterRootPath = null;
        if (filter != null && filter.getPathRestriction().equals((Object)Filter.PathRestriction.ALL_CHILDREN)) {
            filterRootPath = filter.getPath();
        }
        if (filterRootPath != null && (totalNodesCount = NodeCounter.getEstimatedNodeCount(root, "/", true)) != -1L && (filterPathCount = NodeCounter.getEstimatedNodeCount(root, filterRootPath, true)) != -1L) {
            long countScaledDown = (long)((double)count / (double)totalNodesCount * (double)filterPathCount);
            long mostNodesFromThisSubtree = (long)((double)filterPathCount * 0.8);
            count = Math.min(count, mostNodesFromThisSubtree);
            count = Math.max(count, countScaledDown);
        }
        return count;
    }

    NodeBuilder fetchKeyNode(@Nonnull NodeBuilder index, @Nonnull String key) {
        return index.child(key);
    }

    void prune(NodeBuilder index, Deque<NodeBuilder> builders, String key) {
        for (NodeBuilder node : builders) {
            if (node.getBoolean("match") || node.getChildNodeCount(1L) > 0L) {
                return;
            }
            if (!node.exists()) continue;
            node.remove();
        }
    }

    @Override
    public boolean exists(Supplier<NodeBuilder> index, String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIndexNodeName() {
        return this.indexName;
    }

    static class CountingNodeVisitor
    implements NodeVisitor {
        final int maxCount;
        int count;
        int depth;
        long depthTotal;

        CountingNodeVisitor(int maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public void visit(NodeState state) {
            if (state.hasProperty("match")) {
                ++this.count;
                this.depthTotal += (long)this.depth;
            }
            if (this.count < this.maxCount) {
                ++this.depth;
                for (ChildNodeEntry entry : state.getChildNodeEntries()) {
                    if (this.count >= this.maxCount) break;
                    this.visit(entry.getNodeState());
                }
                --this.depth;
            }
        }

        int getCount() {
            return this.count;
        }

        int getEstimatedCount() {
            if (this.count < this.maxCount) {
                return this.count;
            }
            double averageDepth = (int)(this.depthTotal / (long)this.count);
            long estimatedNodes = (long)((double)this.count * Math.pow(1.1, averageDepth));
            estimatedNodes = Math.min(estimatedNodes, Integer.MAX_VALUE);
            return Math.max(this.count, (int)estimatedNodes);
        }
    }

    static interface NodeVisitor {
        public void visit(NodeState var1);
    }

    static class PathIterator
    implements Iterator<String> {
        private final Filter filter;
        private final String indexName;
        private final Deque<Iterator<? extends ChildNodeEntry>> nodeIterators = Queues.newArrayDeque();
        private int readCount;
        private int intermediateNodeReadCount;
        private boolean init;
        private boolean closed;
        private String filterPath;
        private String pathPrefix;
        private String parentPath;
        private String currentPath;
        private boolean pathContainsValue;
        private final boolean prependPathPrefix;
        private final Set<String> knownPaths = Sets.newHashSet();
        private final QueryLimits settings;

        PathIterator(Filter filter, String indexName, String pathPrefix, boolean prependPathPrefix) {
            this.filter = filter;
            this.pathPrefix = pathPrefix;
            this.indexName = indexName;
            boolean shouldDescendDirectly = filter.getPathRestriction().equals((Object)Filter.PathRestriction.ALL_CHILDREN);
            if (shouldDescendDirectly) {
                this.filterPath = filter.getPath();
                if (PathUtils.denotesRoot((String)this.filterPath)) {
                    this.filterPath = "";
                }
            } else {
                this.filterPath = "";
            }
            this.parentPath = "";
            this.currentPath = "/";
            this.settings = filter.getQueryLimits();
            this.prependPathPrefix = prependPathPrefix;
        }

        void enqueue(Iterator<? extends ChildNodeEntry> it) {
            this.nodeIterators.addLast(it);
        }

        void setPathContainsValue(boolean pathContainsValue) {
            if (this.init) {
                throw new IllegalStateException("This iterator is already initialized");
            }
            this.pathContainsValue = pathContainsValue;
        }

        @Override
        public boolean hasNext() {
            if (!this.closed && !this.init) {
                this.fetchNext();
                this.init = true;
            }
            return !this.closed;
        }

        private void fetchNext() {
            do {
                this.fetchNextPossiblyDuplicate();
                if (this.closed) {
                    return;
                }
                if (!this.pathContainsValue) break;
                String value = (String)PathUtils.elements((String)this.currentPath).iterator().next();
                this.currentPath = PathUtils.relativize((String)value, (String)this.currentPath);
            } while (!this.knownPaths.add(this.currentPath));
        }

        private void fetchNextPossiblyDuplicate() {
            while (!this.nodeIterators.isEmpty()) {
                Iterator<? extends ChildNodeEntry> iterator = this.nodeIterators.getLast();
                if (iterator.hasNext()) {
                    ChildNodeEntry entry = iterator.next();
                    NodeState node = entry.getNodeState();
                    String name = entry.getName();
                    if (NodeStateUtils.isHidden((String)name)) continue;
                    this.currentPath = PathUtils.concat((String)this.parentPath, (String)name);
                    if (!"".equals(this.filterPath)) {
                        String p = this.currentPath;
                        if (this.pathContainsValue) {
                            String value = (String)PathUtils.elements((String)p).iterator().next();
                            p = PathUtils.relativize((String)value, (String)p);
                        }
                        if (!"".equals(p = "".equals(this.pathPrefix) ? PathUtils.concat((String)"/", (String)p) : PathUtils.concat((String)this.pathPrefix, (String)p)) && !p.equals(this.filterPath) && !PathUtils.isAncestor((String)p, (String)this.filterPath) && !PathUtils.isAncestor((String)this.filterPath, (String)p)) continue;
                    }
                    this.nodeIterators.addLast(node.getChildNodeEntries().iterator());
                    this.parentPath = this.currentPath;
                    if (node.getBoolean("match")) {
                        ++this.readCount;
                        if (this.readCount % TRAVERSING_WARN == 0) {
                            FilterIterators.checkReadLimit(this.readCount, this.settings);
                            LOG.warn("Index-Traversed {} nodes ({} index entries) using index {} with filter {}", new Object[]{this.readCount, this.intermediateNodeReadCount, this.indexName, this.filter});
                        }
                        return;
                    }
                    ++this.intermediateNodeReadCount;
                    continue;
                }
                this.nodeIterators.removeLast();
                this.parentPath = PathUtils.getParentPath((String)this.parentPath);
            }
            this.currentPath = null;
            this.closed = true;
        }

        @Override
        public String next() {
            if (this.closed) {
                throw new IllegalStateException("This iterator is closed");
            }
            if (!this.init) {
                this.fetchNext();
                this.init = true;
            }
            String result = this.prependPathPrefix ? PathUtils.concat((String)this.pathPrefix, (String)this.currentPath) : this.currentPath;
            this.fetchNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

