/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.commit.AnnotatingConflictHandler;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

final class NodeStoreUtils {
    NodeStoreUtils() {
    }

    static void mergeWithConcurrentCheck(NodeStore nodeStore, NodeBuilder builder) throws CommitFailedException {
        CompositeHook hooks = new CompositeHook(new CommitHook[]{ResetCommitAttributeHook.INSTANCE, new ConflictHook(new AnnotatingConflictHandler()), new EditorHook(CompositeEditorProvider.compose(Collections.singletonList(new ConflictValidatorProvider())))});
        nodeStore.merge(builder, (CommitHook)hooks, NodeStoreUtils.createCommitInfo());
    }

    static void mergeWithConcurrentCheck(NodeStore nodeStore, NodeBuilder builder, IndexEditorProvider indexEditorProvider) throws CommitFailedException {
        CompositeHook hooks = new CompositeHook(new CommitHook[]{ResetCommitAttributeHook.INSTANCE, new EditorHook((EditorProvider)new IndexUpdateProvider(indexEditorProvider, null, true)), new ConflictHook(new AnnotatingConflictHandler()), new EditorHook(CompositeEditorProvider.compose(Collections.singletonList(new ConflictValidatorProvider())))});
        nodeStore.merge(builder, (CommitHook)hooks, NodeStoreUtils.createCommitInfo());
    }

    static NodeBuilder childBuilder(NodeBuilder nb, String path) {
        for (String name : PathUtils.elements((String)((String)Preconditions.checkNotNull((Object)path)))) {
            nb = nb.child(name);
        }
        return nb;
    }

    private static CommitInfo createCommitInfo() {
        ImmutableMap info = ImmutableMap.of((Object)"oak.commitAttributes", (Object)new SimpleCommitContext());
        return new CommitInfo("oak:unknown", "oak:unknown", (Map)info);
    }
}

