/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.index.counter.ApproximateCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterMBean;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterOld;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class NodeCounter
extends AnnotatedStandardMBean
implements NodeCounterMBean {
    public static final boolean COUNT_HASH = Boolean.parseBoolean(System.getProperty("oak.countHashed", "true"));
    public static final boolean USE_OLD_COUNTER = Boolean.getBoolean("oak.index.useCounterOld");
    private final NodeStore store;

    public NodeCounter(NodeStore store) {
        super(NodeCounterMBean.class);
        this.store = store;
    }

    private static NodeState child(NodeState n, String ... path) {
        return NodeCounter.child(n, Arrays.asList(path));
    }

    private static NodeState child(NodeState n, Iterable<String> path) {
        for (String p : path) {
            if (n == null) break;
            if (p.length() <= 0) continue;
            n = n.getChildNode(p);
        }
        return n;
    }

    @Override
    public long getEstimatedNodeCount(String path) {
        return NodeCounter.getEstimatedNodeCount(this.store.getRoot(), path, false);
    }

    public static long getEstimatedNodeCount(NodeState root, String path, boolean max) {
        if (USE_OLD_COUNTER) {
            return NodeCounterOld.getEstimatedNodeCount(root, path, max);
        }
        return NodeCounter.doGetEstimatedNodeCount(root, path, max);
    }

    private static long doGetEstimatedNodeCount(NodeState root, String path, boolean max) {
        long syncCount;
        NodeState s = NodeCounter.child(root, PathUtils.elements((String)path));
        if (s == null || !s.exists()) {
            return 0L;
        }
        if (!max && (syncCount = ApproximateCounter.getCountSync(s)) != -1L) {
            return syncCount;
        }
        if (COUNT_HASH) {
            return NodeCounter.getCombinedCount(root, path, s, max);
        }
        return NodeCounter.getEstimatedNodeCountOld(root, s, path, max);
    }

    private static long getEstimatedNodeCountOld(NodeState root, NodeState s, String path, boolean max) {
        PropertyState p = s.getProperty(":count");
        if (p != null) {
            long x = (Long)p.getValue(Type.LONG);
            if (max) {
                x += 100L;
            }
            return x;
        }
        s = NodeCounter.child(root, "oak:index", "counter");
        if (s == null || !s.exists()) {
            return -1L;
        }
        if (!NodeCounter.dataNodeExists(s)) {
            return -1L;
        }
        long sum = NodeCounter.getIndexingData(s, path).map(n -> n.getProperty(":count")).filter(Objects::nonNull).mapToLong(v -> (Long)v.getValue(Type.LONG)).sum();
        if (sum == 0L) {
            return max ? 2000L : 0L;
        }
        return sum + (long)(max ? 100 : 0);
    }

    private static long getCombinedCount(NodeState root, String path, NodeState s, boolean max) {
        Long value = NodeCounter.getCombinedCountIfAvailable(s);
        if (value != null) {
            return value + (long)(max ? 100 : 0);
        }
        s = NodeCounter.child(root, "oak:index", "counter");
        if (s == null || !s.exists()) {
            return -1L;
        }
        if (!NodeCounter.dataNodeExists(s)) {
            return -1L;
        }
        long sum = NodeCounter.getIndexingData(s, path).map(NodeCounter::getCombinedCountIfAvailable).filter(Objects::nonNull).mapToLong(Long::longValue).sum();
        if (sum == 0L) {
            return max ? 2000L : 0L;
        }
        return sum + (long)(max ? 100 : 0);
    }

    private static Long getCombinedCountIfAvailable(NodeState s) {
        boolean found = false;
        long x = 0L;
        PropertyState p = s.getProperty(":cnt");
        if (p != null) {
            found = true;
            x = (Long)p.getValue(Type.LONG);
        }
        if ((p = s.getProperty(":count")) != null) {
            found = true;
            x += ((Long)p.getValue(Type.LONG)).longValue();
        }
        return found ? Long.valueOf(x) : null;
    }

    @Override
    public String getEstimatedChildNodeCounts(String path, int level) {
        StringBuilder buff = new StringBuilder();
        this.collectCounts(buff, path, level);
        return buff.toString();
    }

    private void collectCounts(StringBuilder buff, String path, int level) {
        long count = this.getEstimatedNodeCount(path);
        if (count > 0L) {
            if (buff.length() > 0) {
                buff.append(",\n");
            }
            buff.append(path).append(": ").append(count);
        }
        if (level <= 0) {
            return;
        }
        NodeState s = NodeCounter.child(this.store.getRoot(), PathUtils.elements((String)path));
        if (!s.exists()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (ChildNodeEntry c : s.getChildNodeEntries()) {
            names.add(c.getName());
        }
        Collections.sort(names);
        for (String cn : names) {
            s.getChildNode(cn);
            String child = PathUtils.concat((String)path, (String)cn);
            this.collectCounts(buff, child, level - 1);
        }
    }

    private static Stream<NodeState> getIndexingData(NodeState indexDefinition, String path) {
        Iterable pathElements = PathUtils.elements((String)path);
        return StreamSupport.stream(indexDefinition.getChildNodeEntries().spliterator(), false).filter(NodeCounter::isDataNodeName).map(ChildNodeEntry::getNodeState).map(n -> NodeCounter.child(n, pathElements)).filter(Objects::nonNull).filter(NodeState::exists);
    }

    private static boolean isDataNodeName(ChildNodeEntry childNodeEntry) {
        String name = childNodeEntry.getName();
        return ":index".equals(name) || name.startsWith(":") && name.endsWith("-" + Multiplexers.stripStartingColon(":index"));
    }

    private static boolean dataNodeExists(NodeState indexDefinition) {
        return StreamSupport.stream(indexDefinition.getChildNodeEntries().spliterator(), false).anyMatch(NodeCounter::isDataNodeName);
    }
}

