/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.cow;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class BranchNodeStore
implements NodeStore,
Observable {
    private static final long CHECKPOINT_LIFETIME = TimeUnit.HOURS.toMillis(24L);
    private final NodeStore nodeStore;
    private final MemoryNodeStore memoryNodeStore;
    private final Collection<String> inheritedCheckpoints;
    private final Map<String, String> checkpointMapping;

    public BranchNodeStore(NodeStore nodeStore) throws CommitFailedException {
        this.nodeStore = nodeStore;
        this.inheritedCheckpoints = Lists.newArrayList((Iterable)nodeStore.checkpoints());
        this.checkpointMapping = Maps.newConcurrentMap();
        String cp = nodeStore.checkpoint(CHECKPOINT_LIFETIME, Collections.singletonMap("type", "copy-on-write"));
        this.memoryNodeStore = new MemoryNodeStore(nodeStore.retrieve(cp));
    }

    public void dispose() {
        for (String cp : this.nodeStore.checkpoints()) {
            if (!"copy-on-write".equals(this.nodeStore.checkpointInfo(cp).get("type"))) continue;
            this.nodeStore.release(cp);
        }
    }

    @Nonnull
    public NodeState getRoot() {
        return this.memoryNodeStore.getRoot();
    }

    @Nonnull
    public synchronized NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        return this.memoryNodeStore.merge(builder, commitHook, info);
    }

    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        return this.memoryNodeStore.rebase(builder);
    }

    public NodeState reset(@Nonnull NodeBuilder builder) {
        return this.memoryNodeStore.reset(builder);
    }

    @Nonnull
    public Blob createBlob(InputStream inputStream) throws IOException {
        return this.memoryNodeStore.createBlob(inputStream);
    }

    public Blob getBlob(@Nonnull String reference) {
        return this.memoryNodeStore.getBlob(reference);
    }

    @Nonnull
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        String checkpoint = this.memoryNodeStore.checkpoint(lifetime, properties);
        String uuid = UUID.randomUUID().toString();
        this.checkpointMapping.put(uuid, checkpoint);
        return uuid;
    }

    @Nonnull
    public String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    @Nonnull
    public Iterable<String> checkpoints() {
        ArrayList result = Lists.newArrayList(this.inheritedCheckpoints);
        result.retainAll(Lists.newArrayList((Iterable)this.nodeStore.checkpoints()));
        this.checkpointMapping.entrySet().stream().filter(e -> this.memoryNodeStore.listCheckpoints().contains(e.getValue())).map(Map.Entry::getKey).forEach(result::add);
        return result;
    }

    @Nonnull
    public Map<String, String> checkpointInfo(@Nonnull String checkpoint) {
        if (this.inheritedCheckpoints.contains(checkpoint)) {
            return this.nodeStore.checkpointInfo(checkpoint);
        }
        if (this.checkpointMapping.containsKey(checkpoint)) {
            return this.memoryNodeStore.checkpointInfo(this.checkpointMapping.get(checkpoint));
        }
        return Collections.emptyMap();
    }

    public NodeState retrieve(@Nonnull String checkpoint) {
        if (this.inheritedCheckpoints.contains(checkpoint)) {
            return this.nodeStore.retrieve(checkpoint);
        }
        if (this.checkpointMapping.containsKey(checkpoint)) {
            return this.memoryNodeStore.retrieve(this.checkpointMapping.get(checkpoint));
        }
        return null;
    }

    public boolean release(@Nonnull String checkpoint) {
        if (this.inheritedCheckpoints.contains(checkpoint)) {
            return this.nodeStore.release(checkpoint);
        }
        if (this.checkpointMapping.containsKey(checkpoint)) {
            return this.memoryNodeStore.release(this.checkpointMapping.remove(checkpoint));
        }
        return false;
    }

    public Closeable addObserver(Observer observer) {
        return this.memoryNodeStore.addObserver(observer);
    }
}

