/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.core.LazyValue;
import org.apache.jackrabbit.oak.core.SecureNodeState;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

class SecureNodeBuilder
implements NodeBuilder {
    private final SecureNodeBuilder rootBuilder;
    private final SecureNodeBuilder parent;
    private final String name;
    private final LazyValue<PermissionProvider> permissionProvider;
    private final NodeBuilder builder;
    private TreePermission treePermission = null;
    private TreePermission rootPermission = null;

    SecureNodeBuilder(@Nonnull NodeBuilder builder, @Nonnull LazyValue<PermissionProvider> permissionProvider) {
        this.rootBuilder = this;
        this.parent = null;
        this.name = null;
        this.permissionProvider = (LazyValue)Preconditions.checkNotNull(permissionProvider);
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
    }

    private SecureNodeBuilder(SecureNodeBuilder parent, String name) {
        this.rootBuilder = parent.rootBuilder;
        this.parent = parent;
        this.name = name;
        this.permissionProvider = parent.permissionProvider;
        this.builder = parent.builder.getChildNode(name);
    }

    @Nonnull
    public NodeState getBaseState() {
        return new SecureNodeState(this.builder.getBaseState(), this.getTreePermission());
    }

    @Nonnull
    public NodeState getNodeState() {
        return new SecureNodeState(this.builder.getNodeState(), this.getTreePermission());
    }

    public boolean exists() {
        return this.builder.exists() && (this.builder.isReplaced() || this.getTreePermission().canRead());
    }

    public boolean isNew() {
        return this.builder.isNew() || this.builder.isReplaced() && !this.getTreePermission().canRead();
    }

    public boolean isNew(String name) {
        return this.builder.isNew(name) || this.builder.isReplaced(name) && !this.getTreePermission().canRead(this.builder.getProperty(name));
    }

    public boolean isModified() {
        return this.builder.isModified();
    }

    public boolean isReplaced() {
        return this.builder.isReplaced() && !this.isNew();
    }

    public boolean isReplaced(String name) {
        return this.builder.isReplaced(name) && !this.isNew(name);
    }

    public void baseChanged() {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
        this.treePermission = null;
        this.rootPermission = null;
    }

    public boolean remove() {
        return this.exists() && this.builder.remove();
    }

    public boolean moveTo(@Nonnull NodeBuilder newParent, @Nonnull String newName) {
        return this.exists() && this.builder.moveTo(newParent, newName);
    }

    @CheckForNull
    public PropertyState getProperty(String name) {
        PropertyState property = this.builder.getProperty(name);
        if (new ReadablePropertyPredicate().apply(property)) {
            return property;
        }
        return null;
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public synchronized long getPropertyCount() {
        if (this.getTreePermission().canReadProperties() || this.isNew()) {
            return this.builder.getPropertyCount();
        }
        return Iterables.size((Iterable)Iterables.filter((Iterable)this.builder.getProperties(), (Predicate)new ReadablePropertyPredicate()));
    }

    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        if (this.getTreePermission().canReadProperties() || this.isNew()) {
            return this.builder.getProperties();
        }
        return Iterables.filter((Iterable)this.builder.getProperties(), (Predicate)new ReadablePropertyPredicate());
    }

    public boolean getBoolean(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        return SecureNodeBuilder.isType(property, Type.BOOLEAN) && (Boolean)property.getValue(Type.BOOLEAN) != false;
    }

    @CheckForNull
    public String getString(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        if (SecureNodeBuilder.isType(property, Type.STRING)) {
            return (String)property.getValue(Type.STRING);
        }
        return null;
    }

    @CheckForNull
    public String getName(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        if (SecureNodeBuilder.isType(property, Type.NAME)) {
            return (String)property.getValue(Type.NAME);
        }
        return null;
    }

    @Nonnull
    public Iterable<String> getNames(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        if (SecureNodeBuilder.isType(property, Type.NAMES)) {
            return (Iterable)property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public NodeBuilder setProperty(@Nonnull PropertyState property) {
        this.builder.setProperty(property);
        return this;
    }

    @Nonnull
    public <T> NodeBuilder setProperty(String name, @Nonnull T value) {
        this.builder.setProperty(name, value);
        return this;
    }

    @Nonnull
    public <T> NodeBuilder setProperty(String name, @Nonnull T value, Type<T> type) {
        this.builder.setProperty(name, value, type);
        return this;
    }

    @Nonnull
    public NodeBuilder removeProperty(String name) {
        if (this.hasProperty(name)) {
            this.builder.removeProperty(name);
        }
        return this;
    }

    @Nonnull
    public Iterable<String> getChildNodeNames() {
        return Iterables.filter((Iterable)this.builder.getChildNodeNames(), input -> input != null && this.getChildNode((String)input).exists());
    }

    public boolean hasChildNode(@Nonnull String name) {
        if (this.builder.hasChildNode(name)) {
            return this.getChildNode(name).exists();
        }
        return false;
    }

    @Nonnull
    public NodeBuilder child(@Nonnull String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    @Nonnull
    public NodeBuilder setChildNode(@Nonnull String name) {
        this.builder.setChildNode(name);
        return new SecureNodeBuilder(this, name);
    }

    @Nonnull
    public NodeBuilder setChildNode(@Nonnull String name, @Nonnull NodeState nodeState) {
        this.builder.setChildNode(name, nodeState);
        return new SecureNodeBuilder(this, name);
    }

    @Nonnull
    public NodeBuilder getChildNode(@Nonnull String name) {
        return new SecureNodeBuilder(this, name);
    }

    public synchronized long getChildNodeCount(long max) {
        if (this.getTreePermission().canReadAll()) {
            return this.builder.getChildNodeCount(max);
        }
        return Iterables.size(this.getChildNodeNames());
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return this.builder.createBlob(stream);
    }

    @Nonnull
    private TreePermission getTreePermission() {
        if (this.treePermission == null || this.rootPermission != this.rootBuilder.treePermission) {
            NodeState base = this.builder.getBaseState();
            if (this.parent == null) {
                Tree baseTree = TreeFactory.createReadOnlyTree(base);
                this.rootPermission = this.treePermission = this.permissionProvider.get().getTreePermission(baseTree, TreePermission.EMPTY);
            } else {
                this.treePermission = this.parent.getTreePermission().getChildPermission(this.name, base);
                this.rootPermission = this.parent.rootPermission;
            }
        }
        return this.treePermission;
    }

    private static boolean isType(@CheckForNull PropertyState property, Type<?> type) {
        Type t = property == null ? null : property.getType();
        return t == type;
    }

    private class ReadablePropertyPredicate
    implements Predicate<PropertyState> {
        private ReadablePropertyPredicate() {
        }

        public boolean apply(@Nullable PropertyState property) {
            if (property != null) {
                String propertyName = property.getName();
                return NodeStateUtils.isHidden((String)propertyName) || SecureNodeBuilder.this.getTreePermission().canRead(property) || SecureNodeBuilder.this.isNew(propertyName);
            }
            return false;
        }
    }
}

