/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.view;

import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;

public class UserManagement
extends ConsoleSlingBean {
    public String getViewType() {
        try {
            JackrabbitSession session = (JackrabbitSession)this.getSession();
            UserManager userManager = session.getUserManager();
            String suffix = this.getRequest().getRequestPathInfo().getSuffix();
            if (suffix != null) {
                Authorizable authorizableByPath = userManager.getAuthorizableByPath(suffix);
                if (authorizableByPath == null) {
                    return "blank";
                }
                if (authorizableByPath.isGroup()) {
                    return "group";
                }
                return "user";
            }
            return "blank";
        }
        catch (RepositoryException e) {
            return "blank";
        }
    }

    public String getPath() {
        String suffix = this.getRequest().getRequestPathInfo().getSuffix();
        return suffix;
    }

    public String getTabType() {
        String selector = this.getRequest().getSelectors((StringFilter)new StringFilter.BlackList("^tab$"));
        return StringUtils.isNotBlank((CharSequence)selector) ? selector.substring(1) : "general";
    }
}

