/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.core;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/bin/cpm/usermanagement"}, methods={"GET", "PUT", "POST", "DELETE"})
public class UserManagementServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UserManagementServlet.class);
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);
    @Reference
    private NodesConfiguration coreConfig;

    protected boolean isEnabled() {
        return this.coreConfig.isEnabled((Servlet)this);
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.authorizables, (ServletOperation)new GetAllAuthorizables());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.users, (ServletOperation)new GetUsers());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.user, (ServletOperation)new GetUser());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.groups, (ServletOperation)new GetGroups());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.group, (ServletOperation)new GetGroup());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.tree, (ServletOperation)new GetTree());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.properties, (ServletOperation)new GetProperties());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.groupsofauthorizable, (ServletOperation)new GetGroupsOfAuthorizable());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.query, (ServletOperation)new QueryAuthorizables());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.user, (ServletOperation)new CreateUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.systemuser, (ServletOperation)new CreateSystemUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.group, (ServletOperation)new CreateGroup());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.disable, (ServletOperation)new DisableUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.enable, (ServletOperation)new EnableUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.password, (ServletOperation)new ChangePassword());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.removefromgroup, (ServletOperation)new RemoveFromGroup());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.addtogroup, (ServletOperation)new AddToGroup());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.authorizable, (ServletOperation)new DeleteAuthorizable());
    }

    protected ServletOperationSet getOperations() {
        return this.operations;
    }

    protected static boolean isSystemUser(Authorizable user) {
        boolean su;
        try {
            Method method = user.getClass().getMethod("isSystemUser", new Class[0]);
            method.setAccessible(true);
            Boolean result = (Boolean)method.invoke((Object)user, new Object[0]);
            su = result == null ? false : result;
        }
        catch (Exception e) {
            su = false;
        }
        return su;
    }

    protected void bindCoreConfig(NodesConfiguration nodesConfiguration) {
        this.coreConfig = nodesConfiguration;
    }

    protected void unbindCoreConfig(NodesConfiguration nodesConfiguration) {
        if (this.coreConfig == nodesConfiguration) {
            this.coreConfig = null;
        }
    }

    public static class GetGroups
    extends GetAuthorizables<Group, GroupEntry> {
        public GetGroups() {
            super(Group.class);
        }

        @Override
        protected GroupEntry processPrincipal(Group group) throws RepositoryException {
            GroupEntry groupEntry = new GroupEntry();
            Principal principal = group.getPrincipal();
            Iterator groupIterator = group.memberOf();
            Iterator declaredMemberOf = group.declaredMemberOf();
            Iterator propertyNames = group.getPropertyNames();
            groupEntry.id = group.getID();
            groupEntry.path = group.getPath();
            groupEntry.principalName = principal.getName();
            groupEntry.memberOf = this.getIDs(groupIterator);
            groupEntry.declaredMemberOf = this.getIDs(declaredMemberOf);
            groupEntry.isGroup = true;
            return groupEntry;
        }
    }

    public static class GetUsers
    extends GetAuthorizables<User, UserEntry> {
        public GetUsers() {
            super(User.class);
        }

        @Override
        protected UserEntry processPrincipal(User user) throws RepositoryException {
            return UserEntry.fromUser(user);
        }
    }

    public static class GetAllAuthorizables
    extends GetAuthorizables<Authorizable, AuthorizableEntry> {
        public GetAllAuthorizables() {
            super(Authorizable.class);
        }

        @Override
        protected AuthorizableEntry processPrincipal(Authorizable authorizable) throws RepositoryException {
            AuthorizableEntry authorizableEntry = new AuthorizableEntry();
            Principal principal = authorizable.getPrincipal();
            Iterator groupIterator = authorizable.memberOf();
            Iterator declaredMemberOf = authorizable.declaredMemberOf();
            authorizableEntry.id = authorizable.getID();
            authorizableEntry.path = authorizable.getPath();
            authorizableEntry.principalName = principal.getName();
            authorizableEntry.memberOf = this.getIDs(groupIterator);
            authorizableEntry.declaredMemberOf = this.getIDs(declaredMemberOf);
            authorizableEntry.isGroup = authorizable.isGroup();
            return authorizableEntry;
        }
    }

    public static class GetGroup
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            if (path == null) {
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            } else {
                UserManager userManager = session.getUserManager();
                Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
                if (authorizable == null) {
                    ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                } else {
                    Group group = (Group)authorizable;
                    GroupEntry groupEntry = GroupEntry.fromGroup(group);
                    String s = new GsonBuilder().create().toJson((Object)groupEntry);
                    response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                    response.setCharacterEncoding(MappingRules.CHARSET.name());
                    PrintWriter writer = response.getWriter();
                    writer.write(s);
                    writer.write(10);
                    writer.flush();
                    writer.close();
                }
            }
        }
    }

    public static class CreateGroup
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            final String name = request.getParameter("groupname");
            String intermediatePath = request.getParameter("intermediatePath");
            Group newGroup = StringUtils.isEmpty((CharSequence)intermediatePath) ? userManager.createGroup(name) : userManager.createGroup(name, new Principal(){

                @Override
                public String getName() {
                    return name;
                }
            }, intermediatePath);
            session.save();
            GroupEntry groupEntry = GroupEntry.fromGroup(newGroup);
            String s = new GsonBuilder().create().toJson((Object)groupEntry);
            response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
            response.setCharacterEncoding(MappingRules.CHARSET.name());
            PrintWriter writer = response.getWriter();
            writer.write(s);
            writer.write(10);
            writer.flush();
            writer.close();
        }
    }

    public static class DeleteAuthorizable
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            if (path != null) {
                String authorizableName = path.substring(path.lastIndexOf(47) + 1);
                if (authorizableName.equals("admin") || authorizableName.equals("anonymous")) {
                    response.sendError(400, authorizableName + " deleted. System destroyed.");
                } else {
                    Authorizable authorizable = userManager.getAuthorizable(authorizableName);
                    if (authorizable == null) {
                        authorizable = userManager.getAuthorizableByPath(path);
                    }
                    if (authorizable != null) {
                        Iterator groupIterator = authorizable.declaredMemberOf();
                        while (groupIterator.hasNext()) {
                            Group group = (Group)groupIterator.next();
                            group.removeMember(authorizable);
                        }
                        authorizable.remove();
                        session.save();
                        ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                    } else {
                        response.sendError(404, authorizableName + " not found.");
                    }
                }
            } else {
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
        }
    }

    public static class CreateUser
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                UserManager userManager = session.getUserManager();
                final String username = request.getParameter("username");
                String password = request.getParameter("password");
                String intermediatePath = request.getParameter("intermediatePath");
                User newUser = StringUtils.isEmpty((CharSequence)intermediatePath) ? userManager.createUser(username, password) : userManager.createUser(username, password, new Principal(){

                    @Override
                    public String getName() {
                        return username;
                    }
                }, intermediatePath);
                session.save();
                UserEntry userEntry = UserEntry.fromUser(newUser);
                String s = new GsonBuilder().create().toJson((Object)userEntry);
                response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                response.setCharacterEncoding(MappingRules.CHARSET.name());
                PrintWriter writer = response.getWriter();
                writer.write(s);
                writer.write(10);
                writer.flush();
                writer.close();
            }
            catch (IllegalArgumentException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                response.sendError(400, e.getMessage());
            }
        }
    }

    public class CreateSystemUser
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                UserManager userManager = session.getUserManager();
                String username = request.getParameter("username");
                String intermediatePath = request.getParameter("intermediatePath");
                Method method = userManager.getClass().getMethod("createSystemUser", String.class, String.class);
                Object newUser = method.invoke((Object)userManager, username, StringUtils.isEmpty((CharSequence)intermediatePath) ? null : intermediatePath);
                session.save();
                UserEntry userEntry = UserEntry.fromUser((User)newUser);
                String s = new GsonBuilder().create().toJson((Object)userEntry);
                PrintWriter writer = response.getWriter();
                response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                response.setCharacterEncoding(MappingRules.CHARSET.name());
                writer.write(s);
                writer.write(10);
                writer.flush();
                writer.close();
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                response.sendError(400, "createSystemUser is not supported on your system");
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryException) {
                    throw (RepositoryException)cause;
                }
                throw new ServletException(cause);
            }
        }
    }

    public static class GetUser
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            if (path == null) {
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            } else {
                UserManager userManager = session.getUserManager();
                Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
                if (authorizable == null) {
                    ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                } else {
                    User user = (User)authorizable;
                    UserEntry userEntry = UserEntry.fromUser(user);
                    String s = new GsonBuilder().create().toJson((Object)userEntry);
                    response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                    response.setCharacterEncoding(MappingRules.CHARSET.name());
                    PrintWriter writer = response.getWriter();
                    writer.write(s);
                    writer.write(10);
                    writer.flush();
                    writer.close();
                }
            }
        }
    }

    public static class EnableUser
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
            User user = (User)authorizable;
            user.disable(null);
            session.save();
            ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
        }
    }

    public static class DisableUser
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            String username = request.getParameter("username");
            String reason = request.getParameter("reason");
            Authorizable authorizable = userManager.getAuthorizable(username);
            User user = (User)authorizable;
            user.disable(reason);
            session.save();
            ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
        }
    }

    public static class ChangePassword
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            Authorizable authorizable = userManager.getAuthorizable(username);
            User user = (User)authorizable;
            user.changePassword(password);
            session.save();
            ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
        }
    }

    public static class GetProperties
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            UserManager userManager = session.getUserManager();
            String[] split = path.split("/");
            String userid = split[1];
            String propPath = split[2];
            Authorizable authorizable = userManager.getAuthorizable(userid);
            try {
                Iterator propertyNames = authorizable.getPropertyNames(propPath);
                HashMap<String, String> p = new HashMap<String, String>();
                while (propertyNames.hasNext()) {
                    String name = (String)propertyNames.next();
                    Value[] property = authorizable.getProperty(propPath + "/" + name);
                    p.put(name, property[0].getString());
                }
                try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                    jsonWriter.beginArray();
                    for (Map.Entry e : p.entrySet()) {
                        jsonWriter.beginObject().name("name").value((String)e.getKey()).name("value").value((String)e.getValue()).endObject();
                    }
                    jsonWriter.endArray();
                    jsonWriter.flush();
                }
            }
            catch (RepositoryException e) {
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
        }
    }

    public static class GetTree
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            String originalRequestPath = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            String requestPath = !originalRequestPath.endsWith("/") ? originalRequestPath + "/" : originalRequestPath;
            int requestPathLength = requestPath.length();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            Query q = new Query(){

                public <T> void build(QueryBuilder<T> builder) {
                    builder.setCondition(builder.nameMatches("%"));
                    builder.setSortOrder("@name", QueryBuilder.Direction.ASCENDING);
                    builder.setSelector(Authorizable.class);
                }
            };
            Iterator authorizables = userManager.findAuthorizables(q);
            HashSet<String> paths = new HashSet<String>();
            HashSet<Authorizable> auths = new HashSet<Authorizable>();
            while (authorizables.hasNext()) {
                Authorizable authorizable = (Authorizable)authorizables.next();
                String path = authorizable.getPath();
                if (!path.startsWith(requestPath)) continue;
                int firstSlashPositionAfterRequestPath = path.substring(requestPathLength).indexOf(47);
                if (firstSlashPositionAfterRequestPath > 0) {
                    String segment = path.substring(requestPathLength, requestPathLength + firstSlashPositionAfterRequestPath);
                    if (paths.contains(segment)) continue;
                    paths.add(segment);
                    continue;
                }
                auths.add(authorizable);
            }
            Authorizable authorizableByRequestPath = userManager.getAuthorizableByPath(requestPath);
            try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                if (authorizableByRequestPath == null) {
                    jsonWriter.beginObject().name("id").value(originalRequestPath).name("text").value(originalRequestPath.equals("/") ? "/" : originalRequestPath.substring(originalRequestPath.lastIndexOf(47) + 1)).name("name").value(originalRequestPath.equals("/") ? "/" : originalRequestPath.substring(originalRequestPath.lastIndexOf(47) + 1)).name("path").value(originalRequestPath).name("children").beginArray();
                } else {
                    jsonWriter.beginObject().name("id").value(authorizableByRequestPath.getPath()).name("text").value(authorizableByRequestPath.getID()).name("name").value(authorizableByRequestPath.getID()).name("path").value(authorizableByRequestPath.getPath()).name("type").value(authorizableByRequestPath.isGroup() ? "group" : "user").name("disabled").value(authorizableByRequestPath.isGroup() ? false : ((User)authorizableByRequestPath).isDisabled()).name("systemUser").value(UserManagementServlet.isSystemUser(authorizableByRequestPath)).name("state").beginObject().name("loaded").value(true).endObject().name("children").beginArray();
                }
                for (String path : paths) {
                    jsonWriter.beginObject().name("id").value(requestPath + path).name("text").value(path).name("name").value(path).name("path").value(requestPath + path).name("state").beginObject().name("loaded").value(false).endObject().endObject();
                }
                for (Authorizable authorizable : auths) {
                    jsonWriter.beginObject().name("id").value(authorizable.getPath()).name("text").value(authorizable.getID()).name("name").value(authorizable.getID()).name("path").value(authorizable.getPath()).name("type").value(authorizable.isGroup() ? "group" : "user").name("disabled").value(authorizable.isGroup() ? false : ((User)authorizable).isDisabled()).name("systemUser").value(UserManagementServlet.isSystemUser(authorizable)).name("state").beginObject().name("loaded").value(true).endObject().endObject();
                }
                jsonWriter.endArray().endObject();
                jsonWriter.flush();
            }
        }
    }

    public static class RemoveFromGroup
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            Gson gson = new Gson();
            Map p = (Map)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream(), MappingRules.CHARSET.name()), Map.class);
            String authorizableName = (String)p.get("authorizable");
            String groupName = (String)p.get("group");
            Authorizable authorizable = userManager.getAuthorizable(authorizableName);
            Group group = (Group)userManager.getAuthorizable(groupName);
            group.removeMember(authorizable);
            session.save();
        }
    }

    public static class AddToGroup
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            String authorizableName = request.getParameter("authorizable");
            String groupName = request.getParameter("group");
            Authorizable authorizable = userManager.getAuthorizable(authorizableName);
            Group group = (Group)userManager.getAuthorizable(groupName);
            boolean b = group.addMember(authorizable);
            session.save();
        }
    }

    public static class GetGroupsOfAuthorizable
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
            Iterator groupIterator = authorizable.declaredMemberOf();
            try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                jsonWriter.beginArray();
                while (groupIterator.hasNext()) {
                    Group group = (Group)groupIterator.next();
                    jsonWriter.value(group.getID());
                }
                jsonWriter.endArray();
                jsonWriter.flush();
            }
        }
    }

    public static class QueryAuthorizables
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            final String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            Query q = new Query(){

                public <T> void build(QueryBuilder<T> builder) {
                    builder.setCondition(builder.nameMatches("%" + (path.startsWith("/") ? path.substring(1) : path) + "%"));
                    builder.setSortOrder("@name", QueryBuilder.Direction.ASCENDING);
                    builder.setSelector(Authorizable.class);
                }
            };
            Iterator principals = userManager.findAuthorizables(q);
            ArrayList<AuthorizableEntry> entries = new ArrayList<AuthorizableEntry>();
            while (principals.hasNext()) {
                AuthorizableEntry entry = this.processPrincipal((Authorizable)principals.next());
                entries.add(entry);
            }
            String s = new GsonBuilder().create().toJson(entries);
            PrintWriter writer = response.getWriter();
            writer.write(s);
            writer.flush();
            writer.close();
        }

        protected AuthorizableEntry processPrincipal(Authorizable authorizable) throws RepositoryException {
            AuthorizableEntry authorizableEntry = new AuthorizableEntry();
            Principal principal = authorizable.getPrincipal();
            authorizableEntry.id = authorizable.getID();
            authorizableEntry.path = authorizable.getPath();
            authorizableEntry.principalName = principal.getName();
            authorizableEntry.isGroup = authorizable.isGroup();
            authorizableEntry.systemUser = UserManagementServlet.isSystemUser(authorizable);
            return authorizableEntry;
        }
    }

    public static abstract class GetAuthorizables<A extends Authorizable, E extends AuthorizableEntry>
    implements ServletOperation {
        private final Class<A> authorizableClass;

        public GetAuthorizables(Class<A> authorizableClass) {
            this.authorizableClass = authorizableClass;
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            Query q = new Query(){

                public <T> void build(QueryBuilder<T> builder) {
                    builder.setCondition(builder.nameMatches("%"));
                    builder.setSortOrder("@name", QueryBuilder.Direction.ASCENDING);
                    builder.setSelector(GetAuthorizables.this.authorizableClass);
                }
            };
            Iterator principals = userManager.findAuthorizables(q);
            ArrayList<E> entries = new ArrayList<E>();
            while (principals.hasNext()) {
                E entry = this.processPrincipal((Authorizable)this.authorizableClass.cast(principals.next()));
                entries.add(entry);
            }
            String s = new GsonBuilder().create().toJson(entries);
            response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
            response.setCharacterEncoding(MappingRules.CHARSET.name());
            PrintWriter writer = response.getWriter();
            writer.write(s);
            writer.flush();
            writer.close();
        }

        protected abstract E processPrincipal(A var1) throws RepositoryException;

        protected String[] getIDs(Iterator<Group> groupIterator) throws RepositoryException {
            ArrayList<String> strings = new ArrayList<String>();
            while (groupIterator.hasNext()) {
                Group group = groupIterator.next();
                strings.add(group.getID());
            }
            return strings.toArray(new String[strings.size()]);
        }
    }

    static class GroupEntry
    extends AuthorizableEntry {
        GroupEntry() {
        }

        static GroupEntry fromGroup(Group group) throws RepositoryException {
            GroupEntry groupEntry = new GroupEntry();
            Iterator groupIterator = group.memberOf();
            Iterator declaredMemberOf = group.declaredMemberOf();
            Iterator members = group.getMembers();
            Iterator declaredMembers = group.getDeclaredMembers();
            groupEntry.id = group.getID();
            groupEntry.path = group.getPath();
            groupEntry.principalName = group.getPrincipal().getName();
            groupEntry.memberOf = GroupEntry.getIDs(groupIterator);
            groupEntry.declaredMemberOf = GroupEntry.getIDs(declaredMemberOf);
            groupEntry.members = GroupEntry.getIDs(members);
            groupEntry.declaredMembers = GroupEntry.getIDs(declaredMembers);
            groupEntry.isGroup = true;
            return groupEntry;
        }
    }

    static class UserEntry
    extends AuthorizableEntry {
        boolean admin;
        boolean disabled;
        String disabledReason;
        Map<String, Object> properties = new HashMap<String, Object>();

        UserEntry() {
        }

        static UserEntry fromUser(User user) throws RepositoryException {
            UserEntry userEntry = new UserEntry();
            Iterator groupIterator = user.memberOf();
            Iterator declaredMemberOf = user.declaredMemberOf();
            Iterator propertyNames = user.getPropertyNames();
            userEntry.id = user.getID();
            userEntry.path = user.getPath();
            userEntry.admin = user.isAdmin();
            userEntry.disabled = user.isDisabled();
            userEntry.disabledReason = user.getDisabledReason();
            userEntry.principalName = user.getPrincipal().getName();
            userEntry.memberOf = UserEntry.getIDs(groupIterator);
            userEntry.declaredMemberOf = UserEntry.getIDs(declaredMemberOf);
            userEntry.isGroup = false;
            userEntry.systemUser = UserManagementServlet.isSystemUser((Authorizable)user);
            while (propertyNames.hasNext()) {
                String name = (String)propertyNames.next();
                Value[] property = user.getProperty(name);
                String[] vs = new String[property.length];
                for (int i = 0; i < property.length; ++i) {
                    vs[i] = property[i].getString();
                }
                userEntry.properties.put(name, vs);
            }
            return userEntry;
        }
    }

    static class AuthorizableEntry {
        String id;
        String path;
        String[] memberOf = new String[0];
        String[] declaredMemberOf = new String[0];
        String[] members = new String[0];
        String[] declaredMembers = new String[0];
        String principalName;
        boolean isGroup;
        boolean systemUser;

        AuthorizableEntry() {
        }

        protected static String[] getIDs(Iterator<? extends Authorizable> authorizableIterator) throws RepositoryException {
            ArrayList<String> strings = new ArrayList<String>();
            while (authorizableIterator.hasNext()) {
                Authorizable authorizable = authorizableIterator.next();
                strings.add(authorizable.getID());
            }
            return strings.toArray(new String[strings.size()]);
        }
    }

    public static enum Operation {
        users,
        user,
        groups,
        tree,
        group,
        authorizable,
        disable,
        enable,
        password,
        groupsofauthorizable,
        removefromgroup,
        addtogroup,
        query,
        systemuser,
        authorizables,
        properties;

    }

    public static enum Extension {
        json,
        html;

    }
}

