/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Map;
import javax.script.SimpleBindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.impl.SlingModelsScriptEngineFactory;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;

class ResourceOverridingRequestWrapper
extends SlingHttpServletRequestWrapper {
    private final Resource resource;
    private final AdapterManager adapterManager;
    private final SlingBindings bindings;

    ResourceOverridingRequestWrapper(SlingHttpServletRequest wrappedRequest, Resource resource, AdapterManager adapterManager, SlingModelsScriptEngineFactory scriptEngineFactory, BindingsValuesProvidersByContext bindingsValuesProvidersByContext) {
        super(wrappedRequest);
        this.resource = resource;
        this.adapterManager = adapterManager;
        SlingBindings existingBindings = (SlingBindings)wrappedRequest.getAttribute(SlingBindings.class.getName());
        SimpleBindings bindings = new SimpleBindings();
        if (existingBindings != null) {
            bindings.put("sling", (Object)existingBindings.getSling());
            bindings.put("response", (Object)existingBindings.getResponse());
            bindings.put("reader", (Object)existingBindings.getReader());
            bindings.put("out", (Object)existingBindings.getOut());
            bindings.put("log", (Object)existingBindings.getLog());
        }
        bindings.put("request", (Object)this);
        bindings.put("resource", (Object)resource);
        bindings.put("resolver", (Object)resource.getResourceResolver());
        scriptEngineFactory.invokeBindingsValuesProviders(bindingsValuesProvidersByContext, bindings);
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        this.bindings = slingBindings;
    }

    public Object getAttribute(String name) {
        if (SlingBindings.class.getName().equals(name)) {
            return this.bindings;
        }
        return super.getAttribute(name);
    }

    public Resource getResource() {
        return this.resource;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return (AdapterType)this.adapterManager.getAdapter((Object)this, type);
    }
}

