/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import ch.qos.logback.core.util.ContextUtil;
import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogConfig;
import org.apache.sling.commons.log.logback.internal.LogWriter;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.config.ConfigAdminSupport;
import org.apache.sling.commons.log.logback.internal.config.ConfigurationException;
import org.apache.sling.commons.log.logback.internal.stacktrace.OSGiAwareExceptionHandling;
import org.apache.sling.commons.log.logback.internal.util.LoggerSpecificEncoder;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigManager
implements LogbackResetListener,
LogConfig.LogWriterProvider {
    public static final String LOG_LEVEL = "org.apache.sling.commons.log.level";
    public static final String LOG_FILE = "org.apache.sling.commons.log.file";
    public static final String LOGBACK_FILE = "org.apache.sling.commons.log.configurationFile";
    public static final String LOG_FILE_NUMBER = "org.apache.sling.commons.log.file.number";
    public static final String LOG_FILE_SIZE = "org.apache.sling.commons.log.file.size";
    public static final String LOG_FILE_BUFFERED = "org.apache.sling.commons.log.file.buffered";
    public static final String LOG_PATTERN = "org.apache.sling.commons.log.pattern";
    public static final String LOG_PATTERN_DEFAULT = "%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n";
    public static final String LOG_LOGGERS = "org.apache.sling.commons.log.names";
    public static final String LOG_ADDITIV = "org.apache.sling.commons.log.additiv";
    public static final String LOG_PACKAGING_DATA = "org.apache.sling.commons.log.packagingDataEnabled";
    public static final String LOG_MAX_CLALLER_DEPTH = "org.apache.sling.commons.log.maxCallerDataDepth";
    public static final String PRINTER_MAX_INCLUDED_FILES = "org.apache.sling.commons.log.maxOldFileCountInDump";
    public static final int PRINTER_MAX_INCLUDED_FILES_DEFAULT = 3;
    public static final String PRINTER_NUM_OF_LINES = "org.apache.sling.commons.log.numOfLines";
    public static final int PRINTER_NUM_OF_LINES_DEFAULT = 1000;
    public static final String LOG_LEVEL_DEFAULT = "INFO";
    public static final String LOG_LEVEL_RESET_TO_DEFAULT = "DEFAULT";
    public static final int LOG_FILE_NUMBER_DEFAULT = 5;
    public static final String LOG_FILE_SIZE_DEFAULT = "'.'yyyy-MM-dd";
    public static final String PID = "org.apache.sling.commons.log.LogManager";
    public static final String FACTORY_PID_WRITERS = "org.apache.sling.commons.log.LogManager.factory.writer";
    public static final String FACTORY_PID_CONFIGS = "org.apache.sling.commons.log.LogManager.factory.config";
    public static final String DEFAULT_CONSOLE_APPENDER_NAME = "org.apache.sling.commons.log.CONSOLE";
    private static final String CONFIG_PID_SET = "org.apache.sling.commons.log.ConfigPids";
    private final LoggerContext loggerContext;
    private final ContextUtil contextUtil;
    private final Map<String, LogWriter> writerByPid;
    private final Map<String, LogWriter> writerByFileName;
    private final Map<String, LogConfig> configByPid;
    private final Map<String, LogConfig> configByCategory;
    private final File rootDir;
    private Dictionary<String, String> defaultConfiguration;
    private final ConfigAdminSupport configAdminSupport;
    private final LogbackManager logbackManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object configLock = new Object();
    private File logbackConfigFile;
    private boolean packagingDataEnabled;
    private int maxCallerDataDepth;
    private int maxOldFileCount;
    private int numOfLines;

    public void internalFailure(String message, Throwable t) {
        if (t != null) {
            this.contextUtil.addError(message, t);
        } else {
            this.contextUtil.addError(message);
        }
        System.err.println(message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    public LogConfigManager(LoggerContext loggerContext, BundleContext bundleContext, String rootDir, LogbackManager logbackManager) {
        this.logbackManager = logbackManager;
        this.loggerContext = loggerContext;
        this.contextUtil = new ContextUtil((Context)loggerContext);
        this.writerByPid = new ConcurrentHashMap<String, LogWriter>();
        this.writerByFileName = new ConcurrentHashMap<String, LogWriter>();
        this.configByPid = new ConcurrentHashMap<String, LogConfig>();
        this.configByCategory = new ConcurrentHashMap<String, LogConfig>();
        this.rootDir = new File(rootDir);
        this.setDefaultConfiguration(this.getBundleConfiguration(bundleContext));
        this.configAdminSupport = new ConfigAdminSupport(bundleContext, this);
    }

    public void setDefaultConfiguration(Dictionary<String, String> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        try {
            this.updateGlobalConfiguration(defaultConfiguration);
        }
        catch (ConfigurationException ce) {
            this.internalFailure(ce.getMessage(), ce);
        }
    }

    public void close() {
        this.configAdminSupport.shutdown();
        this.writerByPid.clear();
        this.writerByFileName.clear();
        this.configByPid.clear();
        this.configByCategory.clear();
        this.defaultConfiguration = null;
    }

    @Override
    public LogWriter getLogWriter(String logWriterName) {
        LogWriter lw = this.writerByFileName.get(logWriterName);
        if (lw == null) {
            lw = this.createImplicitWriter(logWriterName);
        }
        return lw;
    }

    public File getLogbackConfigFile() {
        return this.logbackConfigFile;
    }

    public Iterable<LogConfig> getLogConfigs() {
        return this.configByPid.values();
    }

    public Appender<ILoggingEvent> getDefaultAppender() {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName(DEFAULT_CONSOLE_APPENDER_NAME);
        appender.setContext((Context)this.loggerContext);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(LOG_PATTERN_DEFAULT);
        encoder.setContext((Context)this.loggerContext);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return appender;
    }

    @Override
    public void onResetStart(LoggerContext context) {
    }

    @Override
    public void onResetComplete(LoggerContext context) {
        HashMap<String, Appender<ILoggingEvent>> appendersByName = new HashMap<String, Appender<ILoggingEvent>>();
        Map configuredAppenders = (Map)context.getObject("APPENDER_BAG");
        if (configuredAppenders == null) {
            configuredAppenders = Collections.emptyMap();
        }
        HashMap<Appender<ILoggingEvent>, LoggerSpecificEncoder> encoders = new HashMap<Appender<ILoggingEvent>, LoggerSpecificEncoder>();
        HashSet<String> configPids = new HashSet<String>();
        for (LogConfig config : this.getLogConfigs()) {
            configPids.add(config.getConfigPid());
            Appender<ILoggingEvent> appender = null;
            if (config.isAppenderDefined()) {
                LogWriter lw = config.getLogWriter();
                String appenderName = lw.getAppenderName();
                appender = (Appender<ILoggingEvent>)appendersByName.get(appenderName);
                if (appender == null && (appender = (Appender)configuredAppenders.get(appenderName)) != null) {
                    this.contextUtil.addInfo("Found overriding configuration for appender " + appenderName + " in Logback config. OSGi config would be ignored");
                }
                if (appender == null) {
                    LoggerSpecificEncoder encoder = new LoggerSpecificEncoder(this.getDefaultLayout());
                    appender = lw.createAppender((Context)this.loggerContext, (Encoder<ILoggingEvent>)encoder);
                    encoders.put(appender, encoder);
                    appendersByName.put(appenderName, appender);
                }
                if (encoders.containsKey(appender)) {
                    ((LoggerSpecificEncoder)((Object)encoders.get(appender))).addLogConfig(config);
                }
            }
            for (String category : config.getCategories()) {
                ch.qos.logback.classic.Logger logger = this.loggerContext.getLogger(category);
                if (config.isResetToDefault()) {
                    logger.setLevel(null);
                    logger.setAdditive(true);
                    continue;
                }
                logger.setLevel(config.getLogLevel());
                if (appender == null) continue;
                logger.setAdditive(config.isAdditive());
                logger.addAppender(appender);
                this.contextUtil.addInfo("Registering appender " + appender.getName() + "(" + appender.getClass() + ") with logger " + logger.getName());
            }
        }
        context.putObject(CONFIG_PID_SET, configPids);
    }

    public void updateGlobalConfiguration(Dictionary<String, String> configuration) throws ConfigurationException {
        if (configuration == null) {
            configuration = this.defaultConfiguration;
        }
        this.processGlobalConfig(configuration);
        configuration.put(LOG_LOGGERS, "ROOT");
        String logFile = configuration.get(LOG_FILE);
        if (logFile == null || logFile.trim().length() == 0) {
            configuration.put(LOG_FILE, "CONSOLE");
        }
        this.updateLogWriter(PID, configuration, false);
        this.updateLoggerConfiguration(PID, configuration, false);
        this.logbackManager.configChanged();
    }

    public void updateLogWriter(String pid, Dictionary<?, ?> configuration, boolean performRefresh) throws ConfigurationException {
        if (configuration != null) {
            LogWriter existingWriterByFileName;
            LogWriter oldWriter = this.writerByPid.get(pid);
            String logFileName = (String)configuration.get(LOG_FILE);
            if (logFileName != null && logFileName.trim().length() == 0) {
                logFileName = "CONSOLE";
            }
            if (logFileName != null && !LogConfigManager.isConsole(logFileName) && (existingWriterByFileName = this.writerByFileName.get(logFileName = this.getAbsoluteFilePath(logFileName))) != null && oldWriter != null && !existingWriterByFileName.getConfigurationPID().equals(pid)) {
                throw new ConfigurationException(LOG_FILE, "LogFile " + logFileName + " already configured by configuration " + existingWriterByFileName.getConfigurationPID());
            }
            Object fileNumProp = configuration.get(LOG_FILE_NUMBER);
            int fileNum = -1;
            if (fileNumProp instanceof Number) {
                fileNum = ((Number)fileNumProp).intValue();
            } else if (fileNumProp != null) {
                try {
                    fileNum = Integer.parseInt(fileNumProp.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Object fileSizeProp = configuration.get(LOG_FILE_SIZE);
            String fileSize = null;
            if (fileSizeProp != null) {
                fileSize = fileSizeProp.toString();
            }
            boolean bufferedLogging = Util.toBoolean(configuration.get(LOG_FILE_BUFFERED), false);
            LogWriter newWriter = new LogWriter(pid, this.getAppnderName(logFileName), fileNum, fileSize, logFileName, bufferedLogging);
            if (oldWriter != null) {
                this.writerByFileName.remove(oldWriter.getFileName());
            }
            this.writerByFileName.put(newWriter.getFileName(), newWriter);
            this.writerByPid.put(newWriter.getConfigurationPID(), newWriter);
        } else {
            LogWriter logWriter = this.writerByPid.remove(pid);
            if (logWriter != null) {
                this.writerByFileName.remove(logWriter.getFileName());
            }
        }
        if (performRefresh) {
            this.logbackManager.configChanged();
        }
    }

    public void updateLoggerConfiguration(String pid, Dictionary<?, ?> configuration, boolean performRefresh) throws ConfigurationException {
        if (configuration != null) {
            LogConfig oldConfig;
            Level logLevel;
            boolean resetToDefault;
            String pattern = (String)configuration.get(LOG_PATTERN);
            String level = (String)configuration.get(LOG_LEVEL);
            String fileName = (String)configuration.get(LOG_FILE);
            Set<String> categories = LogConfigManager.toCategoryList(configuration.get(LOG_LOGGERS));
            boolean additiv = configuration.get(LOG_ADDITIV) != null ? Boolean.valueOf(configuration.get(LOG_ADDITIV).toString()) : false;
            if (categories == null) {
                throw new ConfigurationException(LOG_LOGGERS, "Missing categories in configuration " + pid);
            }
            for (String cat : categories) {
                LogConfig cfg = this.configByCategory.get(cat);
                if (cfg == null || pid.equals(cfg.getConfigPid())) continue;
                throw new ConfigurationException(LOG_LOGGERS, "Category " + cat + " already defined by configuration " + cfg.getConfigPid());
            }
            if (level == null) {
                throw new ConfigurationException(LOG_LEVEL, "Value required");
            }
            if (LOG_LEVEL_RESET_TO_DEFAULT.equalsIgnoreCase(level)) {
                resetToDefault = true;
                logLevel = null;
            } else {
                logLevel = Level.toLevel((String)level);
                resetToDefault = false;
            }
            if (pattern == null || pattern.length() == 0) {
                pattern = LOG_PATTERN_DEFAULT;
            }
            if (fileName != null && fileName.trim().length() == 0) {
                fileName = "CONSOLE";
            }
            if (fileName != null && !LogConfigManager.isConsole(fileName)) {
                fileName = this.getAbsoluteFilePath(fileName);
            }
            LogConfig newConfig = new LogConfig(this, pattern, categories, logLevel, fileName, additiv, pid, this.loggerContext, resetToDefault);
            if (this.isPackagingDataEnabled()) {
                newConfig.setPostProcessor((PostCompileProcessor<ILoggingEvent>)new OSGiAwareExceptionHandling(this.logbackManager.getPackageInfoCollector()));
            }
            if ((oldConfig = this.configByPid.get(pid)) != null) {
                this.configByCategory.keySet().removeAll(oldConfig.getCategories());
            }
            for (String cat : categories) {
                this.configByCategory.put(cat, newConfig);
            }
            this.configByPid.put(pid, newConfig);
        } else {
            LogConfig config = this.configByPid.remove(pid);
            if (config != null) {
                this.configByCategory.keySet().removeAll(config.getCategories());
            }
        }
        if (performRefresh) {
            this.logbackManager.configChanged();
        }
    }

    public void checkForNewConfigsWhileStarting(LoggerContext context) {
        Set configPids = (Set)context.getObject(CONFIG_PID_SET);
        if (configPids == null) {
            this.contextUtil.addWarn("Did not find any configPid set");
            return;
        }
        if (!configPids.equals(this.configByPid.keySet())) {
            this.contextUtil.addInfo("Config change detected post start. Scheduling config reload");
            this.logbackManager.configChanged();
        } else {
            this.contextUtil.addInfo("Configured the Logback with " + configPids.size() + " configs");
        }
    }

    public boolean isPackagingDataEnabled() {
        return this.packagingDataEnabled;
    }

    public int getMaxCallerDataDepth() {
        return this.maxCallerDataDepth;
    }

    public int getMaxOldFileCount() {
        return this.maxOldFileCount;
    }

    public int getNumOfLines() {
        return this.numOfLines;
    }

    private Dictionary<String, String> getBundleConfiguration(BundleContext bundleContext) {
        String[] props;
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (String prop : props = new String[]{LOG_LEVEL, LOG_FILE, LOG_FILE_NUMBER, LOG_FILE_SIZE, LOG_PATTERN, LOGBACK_FILE, LOG_PACKAGING_DATA}) {
            String value = bundleContext.getProperty(prop);
            if (value == null) continue;
            ((Dictionary)config).put(prop, value);
        }
        if (((Dictionary)config).get(LOG_LEVEL) == null) {
            ((Dictionary)config).put(LOG_LEVEL, LOG_LEVEL_DEFAULT);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGlobalConfig(Dictionary<String, String> configuration) {
        String packagingData;
        String fileName = configuration.get(LOGBACK_FILE);
        if (fileName != null && !fileName.isEmpty()) {
            File file = new File(this.getAbsoluteFilePath(fileName));
            String path = file.getAbsolutePath();
            if (!file.exists()) {
                this.log.warn("Logback configuration file [{}] does not exist.", (Object)path);
            }
            if (!file.isFile()) {
                this.log.warn("Logback configuration file [{}] is not a file.", (Object)path);
            } else if (!file.canRead()) {
                this.log.warn("Logback configuration [{}]file cannot be read", (Object)path);
            } else {
                Object object = this.configLock;
                synchronized (object) {
                    this.logbackConfigFile = file;
                }
            }
        }
        this.packagingDataEnabled = (packagingData = configuration.get(LOG_PACKAGING_DATA)) != null ? Boolean.valueOf(packagingData.toString()) : false;
        this.maxCallerDataDepth = Util.toInteger(configuration.get(LOG_MAX_CLALLER_DEPTH), 8);
        this.maxOldFileCount = Util.toInteger(configuration.get(PRINTER_MAX_INCLUDED_FILES), 3);
        this.numOfLines = Util.toInteger(configuration.get(PRINTER_NUM_OF_LINES), 1000);
    }

    private LogWriter createImplicitWriter(String logWriterName) {
        LogWriter defaultWriter = this.getDefaultWriter();
        if (defaultWriter == null) {
            throw new IllegalStateException("Default logger configuration must have been configured by now");
        }
        return new LogWriter(this.getAppnderName(logWriterName), logWriterName, defaultWriter.getLogNumber(), defaultWriter.getLogRotation());
    }

    public LogWriter getDefaultWriter() {
        return this.writerByPid.get(PID);
    }

    private LogConfig getDefaultConfig() {
        return this.configByPid.get(PID);
    }

    private Layout<ILoggingEvent> getDefaultLayout() {
        return this.getDefaultConfig().createLayout();
    }

    private String getAbsoluteFilePath(String logFileName) {
        File logFile = new File(logFileName = logFileName.replace('/', File.separatorChar));
        if (!logFile.isAbsolute()) {
            logFile = new File(this.rootDir, logFileName);
            logFileName = logFile.getAbsolutePath();
        }
        return logFileName;
    }

    private String getAppnderName(String filePathAbsolute) {
        String rootDirPath = this.rootDir.getAbsolutePath();
        if (filePathAbsolute.startsWith(rootDirPath)) {
            return filePathAbsolute.substring(rootDirPath.length()).replace('\\', '/');
        }
        return filePathAbsolute;
    }

    private static Set<String> toCategoryList(Object loggers) {
        if (loggers == null) {
            return null;
        }
        HashSet<String> loggerNames = new HashSet<String>();
        if (loggers == "ROOT") {
            loggerNames.add("ROOT");
            return loggerNames;
        }
        List<String> loggerNamesList = Util.toList(loggers);
        loggerNames.addAll(loggerNamesList);
        return loggerNames;
    }

    private static boolean isConsole(String logFileName) {
        return "CONSOLE".equals(logFileName);
    }
}

