/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.Syntax;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractRepeatPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class ListPlugin
extends AbstractRepeatPlugin {
    public ListPlugin() {
        this.name = "list";
        this.priority = 130;
    }

    @Override
    public PluginInvoke invoke(final Expression expression, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private String listVariable;
            private String collectionSizeVar;
            private String collectionNotEmpty;
            private String beginVariable;
            private String stepVariable;
            private String endVariable;
            private String validStartStepEnd;
            {
                this.listVariable = compilerContext.generateVariable("collectionVar");
                this.collectionSizeVar = compilerContext.generateVariable("size");
                this.collectionNotEmpty = compilerContext.generateVariable("notEmpty");
                this.beginVariable = compilerContext.generateVariable("begin");
                this.stepVariable = compilerContext.generateVariable("step");
                this.endVariable = compilerContext.generateVariable("end");
                this.validStartStepEnd = compilerContext.generateVariable("validStartStepEnd");
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                stream.write(new VariableBinding.Start(this.listVariable, expression.getRoot()));
                stream.write(new VariableBinding.Start(this.collectionSizeVar, new UnaryOperation(UnaryOperator.LENGTH, new Identifier(this.listVariable))));
                stream.write(new VariableBinding.Start(this.collectionNotEmpty, new BinaryOperation(BinaryOperator.GT, new Identifier(this.collectionSizeVar), NumericConstant.ZERO)));
                stream.write(new Conditional.Start(this.collectionNotEmpty, true));
                Map<String, ExpressionNode> options = expression.getOptions();
                if (options.containsKey("begin")) {
                    stream.write(new VariableBinding.Start(this.beginVariable, expression.getOptions().get("begin")));
                } else {
                    stream.write(new VariableBinding.Start(this.beginVariable, NumericConstant.ZERO));
                }
                if (options.containsKey("step")) {
                    stream.write(new VariableBinding.Start(this.stepVariable, expression.getOptions().get("step")));
                } else {
                    stream.write(new VariableBinding.Start(this.stepVariable, NumericConstant.ONE));
                }
                if (options.containsKey("end")) {
                    stream.write(new VariableBinding.Start(this.endVariable, expression.getOptions().get("end")));
                } else {
                    stream.write(new VariableBinding.Start(this.endVariable, new Identifier(this.collectionSizeVar)));
                }
                stream.write(new VariableBinding.Start(this.validStartStepEnd, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.LT, new Identifier(this.beginVariable), new Identifier(this.collectionSizeVar)), new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.GEQ, new Identifier(this.beginVariable), NumericConstant.ZERO), new BinaryOperation(BinaryOperator.GT, new Identifier(this.stepVariable), NumericConstant.ZERO))), new BinaryOperation(BinaryOperator.GT, new Identifier(this.endVariable), NumericConstant.ZERO))));
                stream.write(new Conditional.Start(this.validStartStepEnd, true));
            }

            @Override
            public void beforeChildren(PushStream stream) {
                String itemVariable = this.decodeItemVariable();
                String loopStatusVar = Syntax.itemLoopStatusVariable(itemVariable);
                String indexVariable = compilerContext.generateVariable("index");
                stream.write(new Loop.Start(this.listVariable, itemVariable, indexVariable));
                stream.write(new VariableBinding.Start(loopStatusVar, ListPlugin.this.buildStatusObj(indexVariable, this.collectionSizeVar)));
                String stepConditionVariable = compilerContext.generateVariable("stepCondition");
                stream.write(new VariableBinding.Start(stepConditionVariable, new BinaryOperation(BinaryOperator.REM, new BinaryOperation(BinaryOperator.SUB, new Identifier(indexVariable), new Identifier(this.beginVariable)), new Identifier(this.stepVariable))));
                String loopTraversalVariable = compilerContext.generateVariable("traversal");
                stream.write(new VariableBinding.Start(loopTraversalVariable, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.GEQ, new Identifier(indexVariable), new Identifier(this.beginVariable)), new BinaryOperation(BinaryOperator.LEQ, new Identifier(indexVariable), new Identifier(this.endVariable))), new BinaryOperation(BinaryOperator.EQ, new Identifier(stepConditionVariable), NumericConstant.ZERO))));
                stream.write(new Conditional.Start(loopTraversalVariable, true));
            }

            @Override
            public void afterChildren(PushStream stream) {
                stream.write(Conditional.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                stream.write(Loop.END);
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(Conditional.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                stream.write(Conditional.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
            }

            private String decodeItemVariable() {
                String[] args = callInfo.getArguments();
                if (args.length > 0) {
                    return args[0];
                }
                return "item";
            }
        };
    }
}

