/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.filter.Filter;

public abstract class AbstractFilter
implements Filter {
    protected int priority = 100;

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public int compareTo(Filter o) {
        if (this.priority < o.priority()) {
            return -1;
        }
        if (this.priority == o.priority()) {
            return 0;
        }
        return 1;
    }

    protected Map<String, ExpressionNode> getFilterOptions(Expression expression, String ... options) {
        HashMap<String, ExpressionNode> collector = new HashMap<String, ExpressionNode>();
        for (String option : options) {
            ExpressionNode optionNode = expression.removeOption(option);
            if (optionNode == null) continue;
            collector.put(option, optionNode);
        }
        return collector;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }
}

