/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.TernaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.compiler.util.ObjectModel;
import org.apache.sling.scripting.sightly.compiler.util.VariableTracker;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce.EvalResult;

public class ExpressionReducer
implements NodeVisitor<EvalResult> {
    private final VariableTracker<EvalResult> tracker;

    public static EvalResult reduce(ExpressionNode node, VariableTracker<EvalResult> tracker) {
        ExpressionReducer reducer = new ExpressionReducer(tracker);
        return reducer.eval(node);
    }

    private ExpressionReducer(VariableTracker<EvalResult> tracker) {
        this.tracker = tracker;
    }

    private EvalResult eval(ExpressionNode node) {
        try {
            return node.accept(this);
        }
        catch (SightlyCompilerException e) {
            BinaryOperation binaryOperation;
            Expression parentExpression;
            if (node instanceof BinaryOperation && (parentExpression = (binaryOperation = (BinaryOperation)node).getParentExpression()) != null) {
                throw new SightlyCompilerException(e.getMessage(), parentExpression.getRawText());
            }
            throw e;
        }
        catch (Exception e) {
            return EvalResult.nonConstant(node);
        }
    }

    @Override
    public EvalResult evaluate(PropertyAccess propertyAccess) {
        EvalResult target = this.eval(propertyAccess.getTarget());
        EvalResult property = this.eval(propertyAccess.getProperty());
        if (!target.isConstant() || !property.isConstant()) {
            return EvalResult.nonConstant(new PropertyAccess(target.getNode(), property.getNode()));
        }
        return EvalResult.constant(ObjectModel.resolveProperty(target.getValue(), property.getValue()));
    }

    @Override
    public EvalResult evaluate(Identifier identifier) {
        EvalResult result = this.tracker.get(identifier.getName());
        if (result != null && result.isConstant()) {
            return EvalResult.constant(result.getValue());
        }
        return EvalResult.nonConstant(identifier);
    }

    @Override
    public EvalResult evaluate(StringConstant text) {
        return EvalResult.constant(text.getText());
    }

    @Override
    public EvalResult evaluate(BinaryOperation binaryOperation) {
        EvalResult left = this.eval(binaryOperation.getLeftOperand());
        EvalResult right = this.eval(binaryOperation.getRightOperand());
        if (!left.isConstant() || !right.isConstant()) {
            return EvalResult.nonConstant(new BinaryOperation(binaryOperation.getOperator(), left.getNode(), right.getNode()));
        }
        return EvalResult.constant(binaryOperation.getOperator().eval(left.getValue(), right.getValue()));
    }

    @Override
    public EvalResult evaluate(BooleanConstant booleanConstant) {
        return EvalResult.constant(booleanConstant.getValue());
    }

    @Override
    public EvalResult evaluate(NumericConstant numericConstant) {
        return EvalResult.constant(numericConstant.getValue());
    }

    @Override
    public EvalResult evaluate(UnaryOperation unaryOperation) {
        EvalResult target = this.eval(unaryOperation.getTarget());
        if (!target.isConstant()) {
            return EvalResult.nonConstant(new UnaryOperation(unaryOperation.getOperator(), target.getNode()));
        }
        return EvalResult.constant(unaryOperation.getOperator().eval(target.getValue()));
    }

    @Override
    public EvalResult evaluate(TernaryOperator ternaryOperator) {
        EvalResult condition = this.eval(ternaryOperator.getCondition());
        if (!condition.isConstant()) {
            return EvalResult.nonConstant(new TernaryOperator(condition.getNode(), ternaryOperator.getThenBranch(), ternaryOperator.getElseBranch()));
        }
        return ObjectModel.toBoolean(condition.getValue()) ? this.eval(ternaryOperator.getThenBranch()) : this.eval(ternaryOperator.getElseBranch());
    }

    @Override
    public EvalResult evaluate(RuntimeCall runtimeCall) {
        ArrayList<ExpressionNode> nodes = new ArrayList<ExpressionNode>();
        for (ExpressionNode node : runtimeCall.getArguments()) {
            EvalResult result = this.eval(node);
            nodes.add(result.getNode());
        }
        return EvalResult.nonConstant(new RuntimeCall(runtimeCall.getFunctionName(), nodes));
    }

    @Override
    public EvalResult evaluate(MapLiteral mapLiteral) {
        HashMap<String, EvalResult> results = new HashMap<String, EvalResult>();
        boolean isConstant = true;
        for (Map.Entry<String, ExpressionNode> entry : mapLiteral.getMap().entrySet()) {
            EvalResult result = this.eval(entry.getValue());
            results.put(entry.getKey(), result);
            isConstant = isConstant && result.isConstant();
        }
        if (isConstant) {
            HashMap map = new HashMap();
            for (Map.Entry entry : results.entrySet()) {
                map.put(entry.getKey(), ((EvalResult)entry.getValue()).getValue());
            }
            return EvalResult.constant(map);
        }
        HashMap<String, ExpressionNode> literal = new HashMap<String, ExpressionNode>();
        for (Map.Entry entry : results.entrySet()) {
            literal.put((String)entry.getKey(), ((EvalResult)entry.getValue()).getNode());
        }
        return EvalResult.nonConstant(new MapLiteral(literal));
    }

    @Override
    public EvalResult evaluate(ArrayLiteral arrayLiteral) {
        ArrayList<EvalResult> results = new ArrayList<EvalResult>();
        boolean isConstant = true;
        for (ExpressionNode node : arrayLiteral.getItems()) {
            EvalResult result = this.eval(node);
            results.add(result);
            isConstant = isConstant && result.isConstant();
        }
        if (isConstant) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (EvalResult result : results) {
                list.add(result.getValue());
            }
            return EvalResult.constant(list);
        }
        ArrayList<ExpressionNode> literal = new ArrayList<ExpressionNode>();
        for (EvalResult result : results) {
            literal.add(result.getNode());
        }
        return EvalResult.nonConstant(new ArrayLiteral(literal));
    }

    @Override
    public EvalResult evaluate(NullLiteral nullLiteral) {
        return EvalResult.constant(null);
    }
}

