/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl.operator;

import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.GenHelper;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.TypedNode;

public class NumericOpGen
implements BinaryOpGen {
    private final String javaOperator;

    public NumericOpGen(String javaOperator) {
        this.javaOperator = javaOperator;
    }

    @Override
    public Type returnType(Type leftType, Type rightType) {
        return this.commonType(leftType, rightType);
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type commonType = this.commonType(left.getType(), right.getType());
        GenHelper.typeCoercion(source, visitor, left, commonType);
        source.append(" ").append(this.javaOperator).append(" ");
        GenHelper.typeCoercion(source, visitor, right, commonType);
    }

    protected Type commonType(Type leftType, Type rightType) {
        if (leftType == rightType && leftType == Type.LONG) {
            return Type.LONG;
        }
        return Type.DOUBLE;
    }
}

