/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.cpnl.CpnlElFunctions;
import com.composum.sling.cpnl.TagBase;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextTag
extends TagBase {
    private static final Logger LOG = LoggerFactory.getLogger(TextTag.class);
    public static final Map<Type, EscapeFunction> ESCAPE_FUNCTION_MAP = new HashMap<Type, EscapeFunction>();
    protected Type type = Type.text;
    private Object value;
    private String propertyName;
    private boolean escape = true;
    private boolean i18n = false;
    private Format format;
    private String output;

    @Override
    protected void clear() {
        this.type = Type.text;
        this.value = null;
        this.propertyName = null;
        this.format = null;
        this.i18n = false;
        this.escape = true;
        this.output = null;
        super.clear();
    }

    @Override
    protected String getDefaultTagName() {
        return "div";
    }

    @Override
    public int doStartTag() throws JspException {
        int result = super.doStartTag();
        if (this.renderTag()) {
            this.bodyContent = null;
            this.output = null;
            if (this.value == null && this.propertyName != null) {
                Resource resource = TagUtil.getRequest((PageContext)this.pageContext).getResource();
                this.value = ResourceUtil.getValueMap((Resource)resource).get(this.propertyName, Object.class);
            }
            if (this.value != null) {
                if (this.format != null) {
                    String[] stringArray;
                    if (this.format instanceof MessageFormat) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = String.valueOf(this.value);
                    } else {
                        stringArray = this.value;
                    }
                    this.output = this.format.format(stringArray);
                } else {
                    this.output = String.valueOf(this.value);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.output) && this.i18n) {
                this.output = CpnlElFunctions.i18n(this.request, this.output);
            }
            return this.output != null ? 0 : 2;
        }
        return result;
    }

    public int doAfterBody() {
        this.output = this.bodyContent.getString().trim();
        return 0;
    }

    @Override
    protected void renderTagStart() {
    }

    @Override
    protected void renderTagEnd() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.output)) {
                boolean renderTag;
                this.output = TextTag.toString(this.escape ? this.escape(this.output) : this.output);
                JspWriter writer = this.pageContext.getOut();
                boolean bl = renderTag = this.renderTag() && (StringUtils.isNotBlank((CharSequence)this.tagName) || StringUtils.isNotBlank((CharSequence)this.classes));
                if (renderTag) {
                    super.renderTagStart();
                }
                writer.write(this.output);
                if (renderTag) {
                    super.renderTagEnd();
                }
            }
        }
        catch (IOException ioex) {
            LOG.error(ioex.getMessage(), (Throwable)ioex);
        }
    }

    public static String toString(Object value) {
        return value instanceof String ? (String)value : (value != null ? value.toString() : "");
    }

    protected Object escape(Object value) {
        EscapeFunction function = ESCAPE_FUNCTION_MAP.get((Object)this.type);
        return function != null ? function.escape(TagUtil.getRequest((PageContext)this.pageContext), value) : CpnlElFunctions.text(TextTag.toString(value));
    }

    public void setType(String type) {
        this.type = Type.valueOf(type);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setI18n(boolean i18n) {
        this.i18n = i18n;
    }

    public void setFormat(String format) {
        Pattern TEXT_FORMAT_STRING = Pattern.compile("\\{([^}]+)}(.+)$");
        Matcher matcher = TEXT_FORMAT_STRING.matcher(format);
        if (matcher.matches()) {
            switch (matcher.group(1)) {
                case "Message": {
                    this.format = new MessageFormat(matcher.group(2));
                    break;
                }
                case "Date": {
                    this.format = new SimpleDateFormat(matcher.group(2));
                }
            }
        }
    }

    public void setTagClass(String tagClass) {
        this.setClasses(tagClass);
    }

    static {
        ESCAPE_FUNCTION_MAP.put(Type.text, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.text(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.rich, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.rich(request, TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.script, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.script(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.cdata, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.cdata(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.path, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.path(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.value, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.value(value);
            }
        });
    }

    public static interface EscapeFunction {
        public Object escape(SlingHttpServletRequest var1, Object var2);
    }

    public static enum Type {
        text,
        rich,
        script,
        cdata,
        path,
        value;

    }
}

