/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.cpnl.UrlTag;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;

public class FormTag
extends UrlTag {
    private String method;
    private String enctype;
    private String charset;

    @Override
    protected String getDefaultTagName() {
        return "form";
    }

    @Override
    protected String getDefaultUrlAttr() {
        return "action";
    }

    public void setAction(String action) {
        this.setUrl(action);
    }

    @Override
    protected void clear() {
        super.clear();
        this.enctype = null;
        this.method = null;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    protected void writeAttributes(JspWriter writer) throws IOException {
        super.writeAttributes(writer);
        if (StringUtils.isNotBlank((CharSequence)this.charset)) {
            writer.write(" accept-charset=\"");
            writer.write(this.charset);
            writer.write("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.enctype)) {
            writer.write(" enctype=\"");
            writer.write(this.enctype);
            writer.write("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.method)) {
            writer.write(" method=\"");
            writer.write(this.method.toUpperCase());
            writer.write("\"");
        }
    }
}

