/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.RequestBundle;
import com.composum.sling.core.util.LinkUtil;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpnlElFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(CpnlElFunctions.class);
    public static final Pattern HREF_PATTERN = Pattern.compile("(<a(\\s*[^>]*)?\\s*href\\s*=\\s*['\"])([^'\"]+)([\"'])");

    public static String i18n(SlingHttpServletRequest request, String text) {
        String translated;
        block2: {
            translated = null;
            try {
                translated = RequestBundle.get(request).getString(text);
            }
            catch (MissingResourceException mrex) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info(mrex.toString());
            }
        }
        return translated != null ? translated : text;
    }

    public static String child(Resource base, String path) {
        Resource child = base.getChild(path);
        return child != null ? child.getPath() : path;
    }

    public static String url(SlingHttpServletRequest request, String path) {
        return LinkUtil.getUrl(request, path);
    }

    public static String mappedUrl(SlingHttpServletRequest request, String path) {
        return LinkUtil.getMappedUrl(request, path);
    }

    public static String unmappedUrl(SlingHttpServletRequest request, String path) {
        return LinkUtil.getUnmappedUrl(request, path);
    }

    public static String externalUrl(SlingHttpServletRequest request, String path) {
        return LinkUtil.getAbsoluteUrl(request, LinkUtil.getUrl(request, path));
    }

    public static String mappedExternalUrl(SlingHttpServletRequest request, String path) {
        return LinkUtil.getAbsoluteUrl(request, LinkUtil.getMappedUrl(request, path));
    }

    public static String unmappedExternalUrl(SlingHttpServletRequest request, String path) {
        return LinkUtil.getAbsoluteUrl(request, LinkUtil.getUnmappedUrl(request, path));
    }

    public static Object value(Object value) {
        return value;
    }

    public static String text(String value) {
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    public static String rich(SlingHttpServletRequest request, String value) {
        value = CpnlElFunctions.map(request, value);
        return value;
    }

    public static String map(SlingHttpServletRequest request, String value) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = HREF_PATTERN.matcher(value);
        int len = value.length();
        int pos = 0;
        while (matcher.find(pos)) {
            String unmapped = matcher.group(3);
            String mapped = CpnlElFunctions.url(request, unmapped);
            result.append(value, pos, matcher.start());
            result.append(matcher.group(1));
            result.append(mapped);
            result.append(matcher.group(4));
            pos = matcher.end();
        }
        if (pos >= 0 && pos < len) {
            result.append(value, pos, len);
        }
        return result.toString();
    }

    public static String path(String value) {
        return LinkUtil.encodePath(value);
    }

    public static String script(String value) {
        return StringEscapeUtils.escapeEcmaScript((String)value);
    }

    public static String cdata(String value) {
        return "<![CDATA[" + value + "]]>";
    }
}

