/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.SlingBean;
import com.composum.sling.cpnl.CpnlBodyTagSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTag
extends CpnlBodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentTag.class);
    protected String var;
    protected String type;
    protected Integer varScope;
    protected Boolean replace;
    protected SlingBean component;
    private transient Class<? extends SlingBean> componentType;
    private static Map<Class<? extends SlingBean>, Field[]> fieldCache = new ConcurrentHashMap<Class<? extends SlingBean>, Field[]>();
    protected ArrayList<Map<String, Object>> replacedAttributes;
    public static final Map<String, Integer> SCOPES = new HashMap<String, Integer>();

    @Override
    protected void clear() {
        this.var = null;
        this.type = null;
        this.varScope = null;
        this.replace = null;
        this.component = null;
        this.replacedAttributes = null;
        this.componentType = null;
        super.clear();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.getVar() != null) {
            try {
                if (this.available() == null || this.getReplace().booleanValue()) {
                    this.component = this.createComponent();
                    this.setAttribute(this.getVar(), this.component, this.getVarScope());
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error("Class not found: " + this.type, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error("Could not access: " + this.type, (Throwable)ex);
            }
            catch (InstantiationException ex) {
                LOG.error("Could not instantiate: " + this.type, (Throwable)ex);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        this.restoreAttributes();
        this.clear();
        super.doEndTag();
        return 6;
    }

    public void setId(String id) {
        this.setVar(id);
    }

    public void setVar(String id) {
        this.var = id;
    }

    public String getVar() {
        return this.var;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setScope(String key) {
        Integer value = key != null ? SCOPES.get(key.toLowerCase()) : null;
        this.varScope = value != null ? value : null;
    }

    public void setVarScope(Integer value) {
        this.varScope = value;
    }

    public Integer getVarScope() {
        return this.varScope != null ? this.varScope : 1;
    }

    public void setReplace(Boolean flag) {
        this.replace = flag;
    }

    public Boolean getReplace() {
        return this.replace != null ? this.replace : this.getVarScope() == 1;
    }

    protected Class<? extends SlingBean> getComponentType() throws ClassNotFoundException {
        String type;
        if (this.componentType == null && StringUtils.isNotBlank((CharSequence)(type = this.getType()))) {
            this.componentType = this.context.getType(type);
        }
        return this.componentType;
    }

    protected Object available() throws ClassNotFoundException {
        Class<? extends SlingBean> type;
        Object value;
        Object result = null;
        if (this.getVar() != null && (value = this.pageContext.getAttribute(this.getVar(), this.getVarScope().intValue())) instanceof SlingBean && (type = this.getComponentType()) != null && type.isAssignableFrom(value.getClass())) {
            result = value;
        }
        return result;
    }

    protected SlingBean createComponent() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        SlingBean component = null;
        Class<? extends SlingBean> type = this.getComponentType();
        if (type != null) {
            BeanContext baseContext = this.context.withResource(this.getModelResource(this.context));
            component = baseContext.adaptTo(type);
            this.injectServices(component);
            this.additionalInitialization(component);
        }
        return component;
    }

    public Resource getModelResource(BeanContext context) {
        return context.getResource();
    }

    protected void additionalInitialization(SlingBean component) {
    }

    protected void injectServices(SlingBean component) throws IllegalAccessException {
        Field[] declaredFields;
        if (fieldCache.containsKey(component.getClass())) {
            declaredFields = fieldCache.get(component.getClass());
        } else {
            declaredFields = component.getClass().getDeclaredFields();
            fieldCache.put(component.getClass(), declaredFields);
        }
        for (Field field : declaredFields) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (null != field.get(component)) continue;
            String filter = null;
            if (field.isAnnotationPresent(Named.class)) {
                Named name = field.getAnnotation(Named.class);
                filter = "(service.pid=" + name.value() + ")";
            }
            Class<?> typeOfField = field.getType();
            Object o = this.retrieveFirstServiceOfType(typeOfField, filter);
            field.set(component, o);
        }
    }

    protected <T> T retrieveFirstServiceOfType(Class<T> serviceType, String filter) {
        T[] services = null;
        try {
            services = this.context.getServices(serviceType, filter);
        }
        catch (InvalidSyntaxException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return services == null ? null : (T)services[0];
    }

    protected Map<String, Object> getReplacedAttributes(int scope) {
        if (this.replacedAttributes == null) {
            this.replacedAttributes = new ArrayList();
        }
        while (this.replacedAttributes.size() <= scope) {
            this.replacedAttributes.add(new HashMap());
        }
        return this.replacedAttributes.get(scope);
    }

    protected void setAttribute(String key, Object value, int scope) {
        Map<String, Object> replacedInScope = this.getReplacedAttributes(scope);
        if (!replacedInScope.containsKey(key)) {
            Object current = this.pageContext.getAttribute(key, scope);
            replacedInScope.put(key, current);
        }
        this.pageContext.setAttribute(key, value, scope);
    }

    protected void restoreAttributes() {
        if (this.replacedAttributes != null) {
            for (int scope = 0; scope < this.replacedAttributes.size(); ++scope) {
                Map<String, Object> replaced = this.replacedAttributes.get(scope);
                for (Map.Entry<String, Object> entry : replaced.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value != null) {
                        this.pageContext.setAttribute(key, value, scope);
                        continue;
                    }
                    this.pageContext.removeAttribute(key, scope);
                }
            }
        }
    }

    static {
        SCOPES.put("page", 1);
        SCOPES.put("request", 2);
        SCOPES.put("session", 3);
    }
}

