/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.processor.RendererContext;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.cpnl.CpnlBodyTagSupport;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientlibTag
extends CpnlBodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ClientlibTag.class);
    public static final String ALREADY_EMBEDDED = "clientlib.alreadyEmbedded";
    protected Clientlib.Type type;
    protected String path;
    protected String category;
    protected Object test;
    private transient Boolean testResult;

    public void setType(String type) {
        this.type = Clientlib.Type.valueOf(type);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setTest(Object value) {
        this.test = value;
    }

    protected boolean getTestResult() {
        if (this.testResult == null) {
            this.testResult = this.eval(this.test, this.test instanceof Boolean ? (Boolean)this.test : Boolean.TRUE);
        }
        return this.testResult;
    }

    @Override
    protected void clear() {
        super.clear();
        this.type = null;
        this.path = null;
        this.category = null;
        this.test = null;
        this.testResult = null;
    }

    protected Clientlib.Type getType() {
        if (this.type == null) {
            String ext = StringUtils.substringAfterLast((String)this.path, (String)".").toLowerCase();
            try {
                ext = ext.replaceAll("(png|jpg)", "img");
                this.type = Clientlib.Type.valueOf(ext);
            }
            catch (Exception ex) {
                this.type = Clientlib.Type.link;
            }
        }
        return this.type;
    }

    public int doEndTag() throws JspException {
        if (this.getTestResult()) {
            try {
                RendererContext rendererContext = RendererContext.instance(this.context, this.request);
                Clientlib.Type type = this.getType();
                ClientlibRef ref = null;
                if (StringUtils.isNotBlank((CharSequence)this.path)) {
                    ref = new ClientlibRef(type, this.path, false, null);
                    LOG.debug("<cpn:clientlib.{} path={}/>", (Object)type, (Object)this.path);
                } else if (StringUtils.isNotBlank((CharSequence)this.category)) {
                    ref = ClientlibRef.forCategory(type, this.category, false, null);
                    LOG.debug("<cpn:clientlib.{} category={}/>", (Object)type, (Object)this.category);
                } else {
                    LOG.error("No path nor category attribute was given!");
                }
                ClientlibService service = this.context.getService(ClientlibService.class);
                ClientlibElement clientlib = service.resolve(ref, this.request.getResourceResolver());
                if (null != clientlib) {
                    JspWriter writer = this.pageContext.getOut();
                    if (service.getClientlibConfig().getTagDebug()) {
                        writer.println("<!-- cpn:clientlib." + (Object)((Object)type) + " " + (String)ObjectUtils.defaultIfNull((Object)this.path, (Object)"") + " " + (String)ObjectUtils.defaultIfNull((Object)this.category, (Object)"") + " -->");
                    }
                    service.renderClientlibLinks(clientlib, (Writer)writer, this.request, rendererContext);
                } else {
                    LOG.error("No clientlib found for path {} / category {} ");
                }
            }
            catch (IOException | RepositoryException e) {
                LOG.error(e.getMessage(), e);
            }
            super.doEndTag();
        }
        return 6;
    }
}

