/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.JcrResource;
import com.composum.sling.core.util.PropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil
extends org.apache.sling.api.resource.ResourceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtil.class);
    public static final String PROP_RESOURCE_TYPE = "sling:resourceType";
    public static final String PROP_RESOURCE_SUPER_TYPE = "sling:resourceSuperType";
    public static final String CONTENT_NODE = "jcr:content";
    public static final String TYPE_OAKINDEX = "oak:QueryIndexDefinition";
    public static final String TYPE_FOLDER = "nt:folder";
    public static final String TYPE_FILE = "nt:file";
    public static final String TYPE_LINKED_FILE = "nt:linkedFile";
    public static final String TYPE_RESOURCE = "nt:resource";
    public static final String TYPE_UNSTRUCTURED = "nt:unstructured";
    public static final String TYPE_SLING_RESOURCE = "sling:Resource";
    public static final String TYPE_SLING_FOLDER = "sling:Folder";
    public static final String TYPE_SLING_ORDERED_FOLDER = "sling:OrderedFolder";
    public static final String TYPE_LOCKABLE = "mix:lockable";
    public static final String TYPE_ORDERABLE = "mix:orderable";
    public static final String TYPE_REFERENCEABLE = "mix:referenceable";
    public static final String TYPE_LAST_MODIFIED = "mix:lastModified";
    public static final String TYPE_CREATED = "mix:created";
    public static final String TYPE_TITLE = "mix:title";
    public static final String TYPE_VERSIONABLE = "mix:versionable";
    public static final String PROP_UUID = "jcr:uuid";
    public static final String PROP_TITLE = "jcr:title";
    public static final String PROP_DESCRIPTION = "jcr:description";
    public static final String PROP_DATA = "jcr:data";
    public static final String PROP_MIME_TYPE = "jcr:mimeType";
    public static final String PROP_ENCODING = "jcr:encoding";
    public static final String PROP_PRIMARY_TYPE = "jcr:primaryType";
    public static final String PROP_MIXINTYPES = "jcr:mixinTypes";
    public static final String PROP_JCR_CONTENT = "jcr:content";
    public static final String PROP_CREATED = "jcr:created";
    public static final String PROP_LAST_MODIFIED = "jcr:lastModified";
    public static final String PROP_FILE_REFERENCE = "fileReference";

    public static List<Resource> getChildrenByType(Resource resource, List<String> typeSet) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        if (resource != null) {
            block0: for (Resource child : resource.getChildren()) {
                for (String type : typeSet) {
                    if (!ResourceUtil.isResourceType(child, type)) continue;
                    children.add(child);
                    continue block0;
                }
            }
        }
        return children;
    }

    public static List<Resource> getChildrenByType(Resource resource, String type) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        if (resource != null) {
            for (Resource child : resource.getChildren()) {
                if (!ResourceUtil.isResourceType(child, type)) continue;
                children.add(child);
            }
        }
        return children;
    }

    public static List<Resource> getChildrenByResourceType(Resource resource, String resourceType) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        if (resource != null) {
            for (Resource child : resource.getChildren()) {
                if (!child.isResourceType(resourceType)) continue;
                children.add(child);
            }
        }
        return children;
    }

    public static int getIndexOfSameType(Resource resource) {
        if (resource != null) {
            String name = resource.getName();
            String type = resource.getResourceType();
            Resource parent = resource.getParent();
            if (parent != null) {
                int index = 0;
                for (Resource child : parent.getChildren()) {
                    if (type != null && !child.isResourceType(type)) continue;
                    if (name.equals(child.getName())) {
                        return index;
                    }
                    ++index;
                }
            }
        }
        return -1;
    }

    public static Resource getNextOfSameType(Resource resource, boolean wrapAround) {
        if (resource != null) {
            String name = resource.getName();
            String type = resource.getResourceType();
            Resource parent = resource.getParent();
            if (parent != null) {
                boolean returnNext = false;
                for (Resource child : parent.getChildren()) {
                    if (type != null && !child.isResourceType(type)) continue;
                    if (returnNext) {
                        return child;
                    }
                    if (!name.equals(child.getName())) continue;
                    returnNext = true;
                }
                if (returnNext && wrapAround) {
                    for (Resource child : parent.getChildren()) {
                        if (type != null && !child.isResourceType(type)) continue;
                        return child;
                    }
                }
            }
        }
        return null;
    }

    public static String getNameExtension(Resource resource) {
        int dot;
        String extension = null;
        String name = resource.getName();
        if ("jcr:content".equals(name)) {
            name = resource.getParent().getName();
        }
        extension = (dot = name.lastIndexOf(46)) >= 0 ? name.substring(dot + 1).toLowerCase() : "";
        return extension;
    }

    public static String getPrimaryType(Resource resource) {
        String result = null;
        if (resource != null) {
            if (resource instanceof JcrResource) {
                result = ((JcrResource)resource).getPrimaryType();
            } else {
                ValueMap values;
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    try {
                        NodeType type = node.getPrimaryNodeType();
                        if (type != null) {
                            result = type.getName();
                        }
                    }
                    catch (RepositoryException type) {
                        // empty catch block
                    }
                }
                if (result == null && (values = (ValueMap)resource.adaptTo(ValueMap.class)) != null) {
                    result = (String)values.get(PROP_PRIMARY_TYPE, (Object)null);
                }
            }
        }
        return result;
    }

    public static boolean isResourceType(Resource resource, String resourceType) {
        return resource != null && (resource.isResourceType(resourceType) || ResourceUtil.isPrimaryType(resource, resourceType) || ResourceUtil.isNodeType(resource, resourceType));
    }

    public static boolean isPrimaryType(Resource resource, String primaryType) {
        return primaryType.equals(ResourceUtil.getPrimaryType(resource));
    }

    public static boolean isNodeType(Resource resource, String primaryType) {
        if (resource != null) {
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                return node != null && node.isNodeType(primaryType);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Resource getResourceType(Resource resource) {
        return resource != null ? ResourceUtil.getResourceType(resource.getResourceResolver(), resource.getResourceType()) : null;
    }

    public static Resource getResourceType(ResourceResolver resolver, String resourceTypeName) {
        Resource resourceType = null;
        if (StringUtils.isNotBlank((CharSequence)resourceTypeName)) {
            if (resourceTypeName.startsWith("/")) {
                resourceType = resolver.getResource(resourceTypeName);
            } else {
                String[] searchPath;
                for (String path : searchPath = resolver.getSearchPath()) {
                    resourceType = resolver.getResource(path + resourceTypeName);
                    if (resourceType == null) continue;
                    return resourceType;
                }
            }
        }
        return resourceType;
    }

    public static boolean isResourceType(Resource resource, Pattern pattern) {
        return resource != null && ResourceUtil.isResourceType(resource.getResourceResolver(), resource.getResourceType(), pattern);
    }

    public static boolean isResourceType(ResourceResolver resolver, String resourceTypeName, Pattern pattern) {
        if (StringUtils.isNotBlank((CharSequence)resourceTypeName)) {
            if (pattern.matcher(resourceTypeName).find()) {
                return true;
            }
            Resource resourceType = ResourceUtil.getResourceType(resolver, resourceTypeName);
            if (resourceType == null) {
                return false;
            }
            ValueMap values = (ValueMap)resourceType.adaptTo(ValueMap.class);
            String resourceSuperTypeName = (String)values.get(PROP_RESOURCE_SUPER_TYPE, (Object)"");
            return ResourceUtil.isResourceType(resolver, resourceSuperTypeName, pattern);
        }
        return false;
    }

    public static <T> T getTypeProperty(Resource resource, String name, T defaultValue) {
        T value = ResourceUtil.getTypeProperty(resource, name, PropertyUtil.getType(defaultValue));
        return value != null ? value : defaultValue;
    }

    public static <T> T getTypeProperty(Resource resource, String name, Class<T> type) {
        return resource != null ? (T)ResourceUtil.getTypeProperty(resource.getResourceResolver(), resource.getResourceType(), name, type) : null;
    }

    public static <T> T getTypeProperty(ResourceResolver resolver, String resourceTypeName, String name, Class<T> type) {
        ValueMap values;
        Object value = null;
        Resource resourceType = ResourceUtil.getResourceType(resolver, resourceTypeName);
        if (resourceType != null && (value = (values = (ValueMap)resourceType.adaptTo(ValueMap.class)).get(name, type)) == null) {
            String resourceSuperTypeName = (String)values.get(PROP_RESOURCE_SUPER_TYPE, (Object)"");
            value = ResourceUtil.getTypeProperty(resolver, resourceSuperTypeName, name, type);
        }
        return (T)value;
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path) throws RepositoryException {
        return ResourceUtil.getOrCreateResource(resolver, path, null);
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, String primaryTypes) throws RepositoryException {
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            Resource parent;
            int lastTypeSegment;
            int lastPathSegment = path.lastIndexOf(47);
            String parentPath = "/";
            String name = path;
            if (lastPathSegment >= 0) {
                name = path.substring(lastPathSegment + 1);
                parentPath = path.substring(0, lastPathSegment);
                if (StringUtils.isBlank((CharSequence)parentPath)) {
                    parentPath = "/";
                }
            }
            String parentTypes = primaryTypes;
            String type = primaryTypes;
            if (primaryTypes != null && (lastTypeSegment = primaryTypes.lastIndexOf(47)) >= 0) {
                type = primaryTypes.substring(lastTypeSegment + 1);
                parentTypes = primaryTypes.substring(0, lastTypeSegment);
            }
            if ((parent = ResourceUtil.getOrCreateResource(resolver, parentPath, parentTypes)) != null) {
                Node node = (Node)parent.adaptTo(Node.class);
                if (node != null) {
                    if (StringUtils.isNotBlank((CharSequence)type)) {
                        node.addNode(name, type);
                    } else {
                        node.addNode(name);
                    }
                }
                resource = parent.getChild(name);
            }
        }
        return resource;
    }

    public static boolean containsPath(List<Resource> collection, Resource resource) {
        return ResourceUtil.containsPath(collection, resource.getPath());
    }

    public static boolean containsPath(List<Resource> collection, String path) {
        for (Resource item : collection) {
            if (!item.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    public static String[] splitPathAndName(String path) {
        String[] result = new String[2];
        int nameSeparator = path.lastIndexOf(47);
        result[0] = path.substring(0, nameSeparator);
        result[1] = path.substring(nameSeparator + 1);
        return result;
    }

    public static Resource getOrCreateChild(Resource resource, String relPath, String primaryTypes) throws RepositoryException {
        Resource child = null;
        if (resource != null) {
            ResourceResolver resolver = resource.getResourceResolver();
            String path = resource.getPath();
            while (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            if (StringUtils.isNotBlank((CharSequence)relPath)) {
                path = path + "/" + relPath;
            }
            child = ResourceUtil.getOrCreateResource(resolver, path, primaryTypes);
        }
        return child;
    }

    public static boolean isWriteEnabled(Resource resource, String relPath) throws RepositoryException {
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = (Session)resolver.adaptTo(Session.class);
        AccessControlManager accessManager = AccessControlUtil.getAccessControlManager((Session)session);
        String resourcePath = resource.getPath();
        Privilege[] addPrivileges = new Privilege[]{accessManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")};
        boolean result = accessManager.hasPrivileges(resourcePath, addPrivileges);
        if (StringUtils.isNotBlank((CharSequence)relPath)) {
            if (!resourcePath.endsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            resourcePath = resourcePath + relPath;
        }
        Privilege[] changePrivileges = new Privilege[]{accessManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties")};
        try {
            result = result && accessManager.hasPrivileges(resourcePath, changePrivileges);
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isRenderableFile(Resource resource) {
        boolean result = false;
        try {
            NodeType type;
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null && TYPE_FILE.equals((type = node.getPrimaryNodeType()).getName())) {
                String resoureName = resource.getName();
                result = resoureName.toLowerCase().endsWith(".html");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isFile(Resource resource) {
        block15: {
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                try {
                    String typeName;
                    NodeType type = node.getPrimaryNodeType();
                    if (type == null) break block15;
                    switch (typeName = type.getName()) {
                        case "nt:file": {
                            return true;
                        }
                        case "nt:resource": 
                        case "nt:unstructured": {
                            try {
                                Property mimeType = node.getProperty(PROP_MIME_TYPE);
                                if (mimeType != null && StringUtils.isNotBlank((CharSequence)mimeType.getString())) {
                                    node.getProperty(PROP_DATA);
                                    return true;
                                }
                                break;
                            }
                            catch (PathNotFoundException pathNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (RepositoryException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public static Resource getDataResource(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                try {
                    node.getProperty(PROP_DATA);
                    return resource;
                }
                catch (PathNotFoundException pnfex) {
                    Node contentNode = node.getNode("jcr:content");
                    contentNode.getProperty(PROP_DATA);
                    return resource.getChild("jcr:content");
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Binary getBinaryData(Resource resource) {
        return PropertyUtil.getBinaryData((Node)resource.adaptTo(Node.class));
    }
}

