/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.util.LinkMapper;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.tika.mime.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LinkUtil.class);
    public static final String EXT_HTML = ".html";
    public static final String PROP_TARGET = "sling:target";
    public static final String PROP_REDIRECT = "sling:redirect";
    public static final String FORWARDED_SSL_HEADER = "X-Forwarded-SSL";
    public static final String FORWARDED_SSL_ON = "on";
    public static final String URL_PATTERN_STRING = "^(?:(https?|mailto|tel):)?//([^/]+)(:\\d+)?(/.*)?$";
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?|mailto|tel):)?//([^/]+)(:\\d+)?(/.*)?$");
    public static final String SPECIAL_URL_STRING = "^(?:(mailto|tel):)(.+)$";
    public static final Pattern SPECIAL_URL_PATTERN = Pattern.compile("^(?:(mailto|tel):)(.+)$");
    public static final Pattern SELECTOR_PATTERN = Pattern.compile("^(.*/[^/]+)(\\.[^.]+)$");

    public static String getUrl(SlingHttpServletRequest request, String url) {
        return LinkUtil.getUrl(request, url, null, null);
    }

    public static String getMappedUrl(SlingHttpServletRequest request, String url) {
        return LinkUtil.getUrl(request, url, null, null, LinkMapper.RESOLVER);
    }

    public static String getUnmappedUrl(SlingHttpServletRequest request, String url) {
        return LinkUtil.getUrl(request, url, null, null, LinkMapper.CONTEXT);
    }

    public static String getUrl(SlingHttpServletRequest request, String url, String extension) {
        return LinkUtil.getUrl(request, url, null, extension);
    }

    public static String getUrl(SlingHttpServletRequest request, String url, String selectors, String extension) {
        LinkMapper mapper = (LinkMapper)request.getAttribute(LinkMapper.LINK_MAPPER_REQUEST_ATTRIBUTE);
        return LinkUtil.getUrl(request, url, selectors, extension, mapper != null ? mapper : LinkMapper.RESOLVER);
    }

    public static String getUrl(SlingHttpServletRequest request, String url, String selectors, String extension, LinkMapper mapper) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        if (!LinkUtil.isExternalUrl(url)) {
            ResourceResolver resolver = request.getResourceResolver();
            ResourceHandle resource = ResourceHandle.use(resolver.getResource(url));
            if (resource.isValid()) {
                try {
                    String redirect = LinkUtil.getFinalTarget(resource);
                    if (StringUtils.isNotBlank((CharSequence)redirect)) {
                        return LinkUtil.getUrl(request, redirect, selectors, extension, mapper);
                    }
                }
                catch (RedirectLoopException rlex) {
                    LOG.error(rlex.toString());
                }
                extension = LinkUtil.getExtension(resource, extension);
            }
            if (mapper != null) {
                url = mapper.mapUri(request, url);
                url = LinkUtil.adjustMappedUrl(request, url);
            }
            if (StringUtils.isNotBlank((CharSequence)extension)) {
                url = url + extension;
            }
            if (StringUtils.isNotBlank((CharSequence)selectors)) {
                Matcher matcher;
                if (!selectors.startsWith(".")) {
                    selectors = "." + selectors;
                }
                if ((matcher = SELECTOR_PATTERN.matcher(url)).matches()) {
                    url = matcher.group(1) + selectors + matcher.group(2);
                }
            }
        }
        return url;
    }

    public static String getAbsoluteUrl(SlingHttpServletRequest request, String url) {
        if (!LinkUtil.isExternalUrl(url) && url.startsWith("/")) {
            String scheme = request.getScheme().toLowerCase();
            url = scheme + "://" + LinkUtil.getAuthority(request) + url;
        }
        return url;
    }

    public static String getAuthority(SlingHttpServletRequest request) {
        String host = request.getServerName();
        int port = request.getServerPort();
        return port > 0 && port != LinkUtil.getDefaultPort(request) ? host + ":" + port : host;
    }

    public static int getDefaultPort(SlingHttpServletRequest request) {
        if (!request.isSecure()) {
            return 80;
        }
        return FORWARDED_SSL_ON.equalsIgnoreCase(request.getHeader(FORWARDED_SSL_HEADER)) ? 80 : 443;
    }

    protected static String adjustMappedUrl(SlingHttpServletRequest request, String url) {
        Pattern defaultPortPattern = Pattern.compile(URL_PATTERN_STRING.replaceFirst("\\(:\\\\d\\+\\)\\?", ":" + LinkUtil.getDefaultPort(request)));
        Matcher matcher = defaultPortPattern.matcher(url);
        if (matcher.matches()) {
            url = null == matcher.group(1) ? "//" + matcher.group(2) : matcher.group(1) + "://" + matcher.group(2);
            String uri = matcher.group(3);
            url = StringUtils.isNotBlank((CharSequence)uri) ? url + uri : url + "/";
        }
        return url;
    }

    public static boolean isExternalUrl(String url) {
        return URL_PATTERN.matcher(url).matches() || SPECIAL_URL_PATTERN.matcher(url).matches();
    }

    public static Resource resolveUrl(SlingHttpServletRequest request, String url) {
        return request.getResourceResolver().getResource(url);
    }

    public static String getFinalTarget(Resource resource) throws RedirectLoopException {
        ResourceHandle handle = ResourceHandle.use(resource);
        String finalTarget = LinkUtil.getFinalTarget(handle, new ArrayList<String>());
        return finalTarget;
    }

    protected static String getFinalTarget(ResourceHandle resource, List<String> trace) throws RedirectLoopException {
        String finalTarget = null;
        if (resource.isValid()) {
            ResourceHandle contentResource;
            String path = resource.getPath();
            if (trace.contains(path)) {
                throw new RedirectLoopException(trace, path);
            }
            String redirect = resource.getProperty(PROP_TARGET);
            if (StringUtils.isBlank((CharSequence)redirect)) {
                redirect = resource.getProperty(PROP_REDIRECT);
            }
            if (StringUtils.isBlank((CharSequence)redirect) && resource != (contentResource = resource.getContentResource()) && StringUtils.isBlank((CharSequence)(redirect = contentResource.getProperty(PROP_TARGET)))) {
                redirect = contentResource.getProperty(PROP_REDIRECT);
            }
            if (StringUtils.isNotBlank((CharSequence)redirect)) {
                String target;
                ResourceResolver resolver;
                Resource targetResource;
                trace.add(path);
                finalTarget = redirect;
                if (!URL_PATTERN.matcher(finalTarget).matches() && (targetResource = (resolver = resource.getResourceResolver()).getResource(finalTarget)) != null && StringUtils.isNotBlank((CharSequence)(target = LinkUtil.getFinalTarget(ResourceHandle.use(targetResource), trace)))) {
                    finalTarget = target;
                }
            }
        }
        return finalTarget;
    }

    public static String getExtension(ResourceHandle resource, String extension) {
        return LinkUtil.getExtension(resource, extension, false);
    }

    public static String getExtension(ResourceHandle resource, String extension, boolean detectMimeTypeExtension) {
        String name;
        if (StringUtils.isBlank((CharSequence)extension) && detectMimeTypeExtension && resource.isFile()) {
            MimeType mimeType = MimeTypeUtil.getMimeType(resource);
            if (mimeType != null) {
                extension = mimeType.getExtension();
            } else {
                String name2 = resource.getName();
                int lastDot = name2.lastIndexOf(46);
                if (lastDot > 0) {
                    extension = name2.substring(lastDot + 1);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)extension) && (name = resource.getName()).toLowerCase().endsWith(extension.toLowerCase())) {
            extension = "";
        }
        if (extension == null) {
            String primaryType;
            String resourceType = resource.getResourceType();
            if (resourceType != null && (primaryType = resource.getPrimaryType()) != null && !primaryType.equals(resourceType)) {
                extension = EXT_HTML;
            } else {
                ResourceHandle content = resource.getContentResource();
                if (content.isValid() && !ResourceUtil.isNonExistingResource((Resource)content) && (resourceType = content.getResourceType()) != null && (primaryType = content.getPrimaryType()) != null && !primaryType.equals(resourceType)) {
                    extension = EXT_HTML;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)extension) && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        return extension != null ? extension : "";
    }

    public static String encodePath(String path) {
        if (path != null) {
            path = path.replaceAll("/jcr:", "/_jcr_");
            path = path.replaceAll("&", "%26");
            path = path.replaceAll(":", "%3A");
            path = path.replaceAll(";", "%3B");
            path = path.replaceAll(" ", "%20");
        }
        return path;
    }

    public static class RedirectLoopException
    extends Exception {
        public final List<String> trace;
        public final String target;

        public RedirectLoopException(List<String> trace, String target) {
            super("redirect loop detected in '" + trace.get(trace.size() - 1) + "' which redirects to '" + target + "'");
            this.trace = trace;
            this.target = target;
        }
    }
}

