/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/bin/cpm/core/system"}, methods={"GET", "PUT"})
public class SystemServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SystemServlet.class);
    public static final String NODE_TYPES_PATH = "/jcr:system/jcr:nodeTypes";
    public static final String PROP_IS_MIXIN = "jcr:isMixin";
    public static final String ALL_QUERY_KEY = "-- all --";
    @Reference
    private CoreConfiguration coreConfig;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet(Extension.json);
    public static final String[] PROPERTY_TYPES = new String[]{"String", "Boolean", "Long", "Date", "Binary", "Decimal", "Double", "Name", "Path", "URI", "Reference", "WeakReference"};
    protected ResourceFilter PRIMARY_TYPE_FILTER = new PrimaryTypesFilter();
    protected LRUMap PRIMARY_TYPE_CACHE = new LRUMap();
    protected ResourceFilter MIXIN_TYPE_FILTER = new MixinTypesFilter();
    protected LRUMap MIXIN_TYPE_CACHE = new LRUMap();

    @Override
    protected ServletOperationSet getOperations() {
        return this.operations;
    }

    @Override
    protected boolean isEnabled() {
        return this.coreConfig.isEnabled(this);
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.propertyTypes, new GetPropertyTypes());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.primaryTypes, new GetPrimaryTypes());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.mixinTypes, new GetMixinTypes());
    }

    protected void bindCoreConfig(CoreConfiguration coreConfiguration) {
        this.coreConfig = coreConfiguration;
    }

    protected void unbindCoreConfig(CoreConfiguration coreConfiguration) {
        if (this.coreConfig == coreConfiguration) {
            this.coreConfig = null;
        }
    }

    public class GetNodeTypes
    implements ServletOperation {
        private ResourceFilter typeFilter;
        private LRUMap queryCache;

        public GetNodeTypes(ResourceFilter nameFilter, LRUMap cache) {
            this.typeFilter = nameFilter;
            this.queryCache = cache;
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                String query = request.getParameter("query");
                ResourceResolver resolver = request.getResourceResolver();
                List<String> nodeTypes = (List<String>)this.queryCache.get((Object)(query == null ? SystemServlet.ALL_QUERY_KEY : query));
                if (nodeTypes == null) {
                    nodeTypes = this.getNodeTypes(resolver, query != null ? query.toLowerCase() : null);
                    this.queryCache.put((Object)(query == null ? SystemServlet.ALL_QUERY_KEY : query), nodeTypes);
                }
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
                response.setStatus(200);
                JsonUtil.writeJsonArray(jsonWriter, nodeTypes.iterator());
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }

        public List<String> getNodeTypes(ResourceResolver resolver, String query) throws RepositoryException {
            ArrayList<String> nodeTypes = new ArrayList<String>();
            Resource typesResource = resolver.getResource(SystemServlet.NODE_TYPES_PATH);
            for (Resource type : typesResource.getChildren()) {
                String name = type.getName();
                if (!this.typeFilter.accept(type) || query != null && !name.toLowerCase().contains(query)) continue;
                nodeTypes.add(name);
            }
            Collections.sort(nodeTypes);
            return nodeTypes;
        }
    }

    public class GetMixinTypes
    extends GetNodeTypes {
        public GetMixinTypes() {
            super(SystemServlet.this.MIXIN_TYPE_FILTER, SystemServlet.this.MIXIN_TYPE_CACHE);
        }
    }

    public class GetPrimaryTypes
    extends GetNodeTypes {
        public GetPrimaryTypes() {
            super(SystemServlet.this.PRIMARY_TYPE_FILTER, SystemServlet.this.PRIMARY_TYPE_CACHE);
        }
    }

    public static class PrimaryTypesFilter
    extends MixinTypesFilter {
        @Override
        public boolean accept(Resource resource) {
            return !super.accept(resource);
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("PrimaryTypes");
        }
    }

    public static class MixinTypesFilter
    implements ResourceFilter {
        @Override
        public boolean accept(Resource resource) {
            ResourceHandle handle = ResourceHandle.use(resource);
            Boolean isMixin = handle.getProperty(SystemServlet.PROP_IS_MIXIN, false);
            return isMixin;
        }

        @Override
        public boolean isRestriction() {
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("MixinTypes");
        }
    }

    public class GetPropertyTypes
    implements ServletOperation {
        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
            response.setStatus(200);
            JsonUtil.writeJsonArray(jsonWriter, PROPERTY_TYPES);
        }
    }

    public static enum Operation {
        propertyTypes,
        primaryTypes,
        mixinTypes;

    }

    public static enum Extension {
        json;

    }
}

