/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.concurrent.JobFacade;
import com.composum.sling.core.concurrent.JobUtil;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/bin/cpm/core/jobcontrol"}, methods={"GET", "PUT", "POST", "DELETE"})
public class JobControlServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JobControlServlet.class);
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet(Extension.json);
    @Reference
    private CoreConfiguration coreConfig;
    @Reference
    private JobManager jobManager;

    @Override
    protected boolean isEnabled() {
        return this.coreConfig.isEnabled(this);
    }

    @Override
    protected ServletOperationSet getOperations() {
        return this.operations;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.jobs, new GetAllJobs());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.job, new GetJob());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.txt, Operation.outfile, new GetOutfile());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.job, new CreateJob());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.cleanup, new PurgeAudit());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, Extension.json, Operation.job, new CancelJob());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, Extension.json, Operation.cleanup, new CleanupJob());
    }

    private void job2json(JsonWriter jsonWriter, JobFacade job) throws IOException {
        jsonWriter.beginObject();
        Set<String> propertyNames = Collections.unmodifiableSet(job.getPropertyNames());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (String propertyName : propertyNames) {
            Object property = job.getProperty(propertyName);
            if (property instanceof Calendar) {
                dateFormat.setTimeZone(((Calendar)property).getTimeZone());
                jsonWriter.name(propertyName).value(dateFormat.format(((Calendar)property).getTime()));
                continue;
            }
            if (property instanceof Boolean) {
                jsonWriter.name(propertyName).value((Boolean)property);
                continue;
            }
            if (property instanceof Long) {
                jsonWriter.name(propertyName).value((Long)property);
                continue;
            }
            if (property instanceof Number) {
                jsonWriter.name(propertyName).value((Number)property);
                continue;
            }
            if (property instanceof String) {
                String s = (String)property;
                if (propertyName.equals("outfile")) {
                    jsonWriter.name(propertyName).value(s.substring(s.lastIndexOf(47) + 1));
                    continue;
                }
                jsonWriter.name(propertyName).value(s);
                continue;
            }
            if (property instanceof Object[]) {
                jsonWriter.name(propertyName);
                jsonWriter.beginArray();
                for (Object o : (Object[])property) {
                    jsonWriter.value(String.valueOf(o));
                }
                jsonWriter.endArray();
                continue;
            }
            jsonWriter.name(propertyName).value(String.valueOf(property));
        }
        jsonWriter.name("jobState").value(job.getJobState().name());
        jsonWriter.endObject();
    }

    protected void bindCoreConfig(CoreConfiguration coreConfiguration) {
        this.coreConfig = coreConfiguration;
    }

    protected void unbindCoreConfig(CoreConfiguration coreConfiguration) {
        if (this.coreConfig == coreConfiguration) {
            this.coreConfig = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    private class CreateJob
    implements ServletOperation {
        private CreateJob() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException {
            ResourceResolver resolver = request.getResourceResolver();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            String topic = "";
            HashMap<String, Object> properties = new HashMap<String, Object>();
            Map parameters = request.getParameterMap();
            for (Map.Entry parameter : parameters.entrySet()) {
                if (((String)parameter.getKey()).equals("event.job.topic")) {
                    topic = ((String[])parameter.getValue())[0];
                    continue;
                }
                String[] value = (String[])parameter.getValue();
                if (value.length == 1) {
                    properties.put((String)parameter.getKey(), value[0]);
                    continue;
                }
                properties.put((String)parameter.getKey(), value);
            }
            properties.put("userid", session.getUserID());
            JobUtil.buildOutfileName(properties);
            Job job = JobControlServlet.this.jobManager.addJob(topic, properties);
            try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);){
                JobControlServlet.this.job2json(jsonWriter, new JobFacade.EventJob(job));
            }
        }
    }

    private class CleanupJob
    implements ServletOperation {
        private CleanupJob() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                Resource audit;
                String path = AbstractServiceServlet.getPath(request);
                String jobId = path.substring(1);
                Job job = JobControlServlet.this.jobManager.getJobById(jobId);
                String outfile = (String)job.getProperty("outfile", String.class);
                String topic = (String)job.getProperty("event.job.topic", String.class);
                ResourceResolver resolver = request.getResourceResolver();
                Iterator resources = resolver.findResources("/jcr:root/var/audit/jobs/" + topic + "//*[slingevent:eventId='" + jobId + "']", "xpath");
                boolean auditResourceDeleted = false;
                if (resources.hasNext() && (audit = (Resource)resources.next()) != null && !ResourceUtil.isNonExistingResource((Resource)audit)) {
                    resolver.delete(audit);
                    resolver.commit();
                    auditResourceDeleted = true;
                }
                boolean b = new File(outfile).delete();
                try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);){
                    jsonWriter.beginObject().name("audit").value(auditResourceDeleted).name("outfile").value(b).endObject();
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    private class PurgeAudit
    implements ServletOperation {
        private PurgeAudit() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                int keep = Integer.parseInt(request.getRequestParameter("keep").getString());
                RequestParameter reference = request.getRequestParameter("reference");
                RequestParameter topic = request.getRequestParameter("event.job.topic");
                if (reference != null) {
                    String referenceString = reference.getString();
                    String query = "/jcr:root/var/audit/jobs/" + topic.getString().replaceAll("/", ".") + referenceString + "/*[@slingevent:eventId]";
                    Iterator auditResources = resolver.findResources(query, "xpath");
                    this.removeAudits(resolver, keep, auditResources);
                } else {
                    String allAuditsQuery = "/jcr:root/var/audit/jobs/" + topic.getString().replaceAll("/", ".") + "//*[@slingevent:eventId]";
                    Iterator allAuditResources = resolver.findResources(allAuditsQuery, "xpath");
                    HashSet<String> referencePaths = new HashSet<String>();
                    while (allAuditResources.hasNext()) {
                        Resource auditResource = (Resource)allAuditResources.next();
                        String referencePath = auditResource.getParent().getPath();
                        referencePaths.add(referencePath);
                    }
                    for (String path : referencePaths) {
                        Resource referenceResource = resolver.getResource(path);
                        Iterable auditResources = referenceResource.getChildren();
                        this.removeAudits(resolver, keep, auditResources.iterator());
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                response.sendError(400, e.getMessage());
            }
        }

        private void removeAudits(ResourceResolver resolver, int keep, Iterator<Resource> auditResources) throws PersistenceException {
            ArrayList<JobFacade.AuditJob> allAuditJobs = new ArrayList<JobFacade.AuditJob>();
            while (auditResources.hasNext()) {
                Resource auditResource = auditResources.next();
                JobFacade.AuditJob auditJob = new JobFacade.AuditJob(auditResource);
                allAuditJobs.add(auditJob);
            }
            JobUtil.JobComparator comparator = new JobUtil.JobComparator();
            Collections.sort(allAuditJobs, comparator);
            int size = allAuditJobs.size();
            for (int i = 0; i < size - keep; ++i) {
                JobFacade.AuditJob x = (JobFacade.AuditJob)allAuditJobs.get(i);
                resolver.delete(x.resource);
            }
            resolver.commit();
        }
    }

    private class CancelJob
    implements ServletOperation {
        private CancelJob() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) {
            String path = AbstractServiceServlet.getPath(request);
            String jobId = path.substring(1);
            JobControlServlet.this.jobManager.stopJobById(jobId);
        }
    }

    private class GetJob
    implements ServletOperation {
        private GetJob() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException {
            String path = AbstractServiceServlet.getPath(request);
            String jobId = path.substring(1);
            JobFacade job = JobUtil.getJobById(JobControlServlet.this.jobManager, request.getResourceResolver(), jobId);
            if (job != null) {
                try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);){
                    JobControlServlet.this.job2json(jsonWriter, job);
                }
            }
        }
    }

    private class GetAllJobs
    implements ServletOperation {
        private GetAllJobs() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException {
            String path = AbstractServiceServlet.getPath(request);
            RequestParameter topic = request.getRequestParameter("topic");
            JobManager.QueryType selector = RequestUtil.getSelector(request, JobManager.QueryType.ALL);
            boolean useAudit = selector == JobManager.QueryType.ALL || selector == JobManager.QueryType.HISTORY || selector == JobManager.QueryType.SUCCEEDED;
            Collection jobs = JobControlServlet.this.jobManager.findJobs(selector, topic.getString(), 0L, new Map[0]);
            ArrayList<JobFacade> allJobs = new ArrayList<JobFacade>();
            for (Job job : jobs) {
                allJobs.add(new JobFacade.EventJob(job));
            }
            if (useAudit) {
                Collection<JobFacade> auditJobs = JobUtil.getAuditJobs(selector, request.getResourceResolver());
                for (JobFacade auditJob : auditJobs) {
                    if (this.containsJob(jobs, auditJob)) continue;
                    allJobs.add(auditJob);
                }
            }
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
            Object object = null;
            try {
                Collections.sort(allJobs, new Comparator<JobFacade>(){

                    @Override
                    public int compare(JobFacade o1, JobFacade o2) {
                        return o1.getCreated().compareTo(o2.getCreated());
                    }
                });
                jsonWriter.beginArray();
                for (JobFacade job : allJobs) {
                    if (path.length() > 1) {
                        String script = (String)((Object)job.getProperty("reference", String.class));
                        if (script == null || !script.equals(path)) continue;
                        JobControlServlet.this.job2json(jsonWriter, job);
                        continue;
                    }
                    JobControlServlet.this.job2json(jsonWriter, job);
                }
                jsonWriter.endArray();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (jsonWriter != null) {
                    if (object != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        jsonWriter.close();
                    }
                }
            }
        }

        private boolean containsJob(Collection<Job> jobs, JobFacade jobToFind) {
            for (Job job : jobs) {
                if (!job.getId().equals(jobToFind.getId())) continue;
                return true;
            }
            return false;
        }
    }

    private class GetOutfile
    implements ServletOperation {
        private GetOutfile() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException {
            String jobId = AbstractServiceServlet.getPath(request).substring(1);
            JobFacade job = JobUtil.getJobById(JobControlServlet.this.jobManager, request.getResourceResolver(), jobId);
            if (job != null) {
                String path = (String)((Object)job.getProperty("outfile", String.class));
                String range = request.getHeader("Range");
                List<Range> ranges = this.decodeRange(range);
                File file = new File(path);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/plain;charset=utf-8");
                if (file.exists()) {
                    try (ServletOutputStream outputStream = response.getOutputStream();
                         FileInputStream inputStream = new FileInputStream(file);){
                        this.writeStream(ranges, outputStream, inputStream);
                    }
                    catch (FileNotFoundException e) {
                        response.sendError(404, path);
                    }
                } else {
                    ResourceResolver resolver = request.getResourceResolver();
                    Iterator resources = resolver.findResources("/jcr:root/var/audit/jobs//*[outfile='" + path + "']", "xpath");
                    if (resources.hasNext()) {
                        Resource audit = (Resource)resources.next();
                        Resource outfileResource = resolver.getResource(audit, path.substring(path.lastIndexOf(47) + 1));
                        try (ServletOutputStream outputStream = response.getOutputStream();
                             InputStream inputStream = (InputStream)outfileResource.adaptTo(InputStream.class);){
                            this.writeStream(ranges, outputStream, inputStream);
                        }
                    }
                }
            } else {
                response.sendError(404);
            }
        }

        private void writeStream(List<Range> ranges, ServletOutputStream outputStream, InputStream inputStream) throws IOException {
            int read;
            long end = Long.MAX_VALUE;
            long pos = 0L;
            if (!ranges.isEmpty()) {
                Range range1 = ranges.get(0);
                if (range1.start != null) {
                    inputStream.skip(range1.start.intValue());
                    pos = range1.start.intValue();
                }
                if (range1.end != null) {
                    end = range1.end.intValue();
                }
            }
            while ((read = inputStream.read()) >= 0 && pos <= end) {
                outputStream.write(read);
                ++pos;
            }
        }

        private List<Range> decodeRange(String rangeHeader) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            if (StringUtils.isEmpty((CharSequence)rangeHeader)) {
                ranges.add(new Range());
                return ranges;
            }
            String byteRangeSetRegex = "(((?<byteRangeSpec>(?<firstBytePos>\\d+)-(?<lastBytePos>\\d+)?)|(?<suffixByteRangeSpec>-(?<suffixLength>\\d+)))(,|$))";
            String byteRangesSpecifierRegex = "bytes=(?<byteRangeSet>" + byteRangeSetRegex + "{1,})";
            Pattern byteRangeSetPattern = Pattern.compile(byteRangeSetRegex);
            Pattern byteRangesSpecifierPattern = Pattern.compile(byteRangesSpecifierRegex);
            Matcher byteRangesSpecifierMatcher = byteRangesSpecifierPattern.matcher(rangeHeader);
            if (byteRangesSpecifierMatcher.matches()) {
                String byteRangeSet = byteRangesSpecifierMatcher.group("byteRangeSet");
                Matcher byteRangeSetMatcher = byteRangeSetPattern.matcher(byteRangeSet);
                while (byteRangeSetMatcher.find()) {
                    Range range = new Range();
                    if (byteRangeSetMatcher.group("byteRangeSpec") != null) {
                        String start = byteRangeSetMatcher.group("firstBytePos");
                        String end = byteRangeSetMatcher.group("lastBytePos");
                        range.start = Integer.valueOf(start);
                        range.end = end == null ? null : Integer.valueOf(end);
                    } else if (byteRangeSetMatcher.group("suffixByteRangeSpec") != null) {
                        range.suffixLength = Integer.valueOf(byteRangeSetMatcher.group("suffixLength"));
                    } else {
                        return Collections.emptyList();
                    }
                    ranges.add(range);
                }
            } else {
                return Collections.emptyList();
            }
            return ranges;
        }

        class Range {
            Integer start;
            Integer end;
            Integer suffixLength;

            Range() {
            }
        }
    }

    public static enum Operation {
        job,
        jobs,
        outfile,
        cleanup;

    }

    public static enum Extension {
        txt,
        json;

    }
}

