/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.cpnl.CpnlElFunctions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Component(componentAbstract=true)
public abstract class AbstractServiceServlet
extends SlingAllMethodsServlet {
    public static final String PARAM_FILE = "file";
    public static final String PARAM_CMD = "cmd";
    public static final String PARAM_FILTER = "filter";
    public static final String PARAM_ID = "id";
    public static final String PARAM_INDEX = "index";
    public static final String PARAM_JCR_CONTENT = "jcrContent";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_MIME_TYPE = "mimeType";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_BEFORE = "before";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_RESOURCE_TYPE = "resourceType";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_URL = "url";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_VERSION = "version";

    protected abstract boolean isEnabled();

    protected boolean isEnabled(SlingHttpServletResponse response) {
        boolean enabled = this.isEnabled();
        if (!enabled) {
            response.setContentLength(0);
            response.setStatus(503);
        }
        return enabled;
    }

    protected abstract ServletOperationSet getOperations();

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(response)) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doGet(request, response);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(response)) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doPost(request, response);
        }
    }

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(response)) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doPut(request, response);
        }
    }

    protected void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(response)) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doDelete(request, response);
        }
    }

    public static void setNoCacheHeaders(SlingHttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static ResourceHandle getResource(SlingHttpServletRequest request) {
        ResourceResolver resolver = request.getResourceResolver();
        String path = AbstractServiceServlet.getPath(request);
        ResourceHandle resource = ResourceHandle.use(resolver.resolve(path));
        return resource;
    }

    public static String getPath(SlingHttpServletRequest request) {
        RequestPathInfo reqPathInfo = request.getRequestPathInfo();
        String path = reqPathInfo.getSuffix();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = request.getParameter(PARAM_PATH);
        }
        return path;
    }

    protected void jsonAnswerItemExists(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setStatus(409);
        JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
        jsonWriter.beginObject();
        jsonWriter.name("success").value(false);
        jsonWriter.name("response").beginObject();
        jsonWriter.name("level").value("warn");
        jsonWriter.name("text").value(CpnlElFunctions.i18n(request, "An element with the same name exists already - use a different name!"));
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    public static <T> T getJsonObject(SlingHttpServletRequest request, Class<T> type) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, MappingRules.CHARSET.name());
        Gson gson = JsonUtil.GSON_BUILDER.create();
        T object = gson.fromJson((Reader)inputReader, type);
        return object;
    }

    public static <T> T getJsonObject(SlingHttpServletRequest request, Class<T> type, InstanceCreator<T> instanceCreator) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, MappingRules.CHARSET.name());
        Gson gson = new GsonBuilder().registerTypeAdapter(type, instanceCreator).create();
        return gson.fromJson((Reader)inputReader, type);
    }

    public static <T> T getJsonObject(String input, Class<T> type) throws IOException {
        StringReader inputReader = new StringReader(input);
        Gson gson = JsonUtil.GSON_BUILDER.create();
        T object = gson.fromJson((Reader)inputReader, type);
        return object;
    }
}

