/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.util.LinkUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.framework.BundleContext;

public abstract class AbstractConsoleServlet
extends SlingSafeMethodsServlet {
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected abstract Pattern getPathPattern(BeanContext var1);

    protected abstract String getResourceType(BeanContext var1);

    protected String getConsolePath(BeanContext context) {
        return null;
    }

    protected String getRequestPath(SlingHttpServletRequest request) {
        RequestPathInfo reqPathInfo = request.getRequestPathInfo();
        String suffix = reqPathInfo.getSuffix();
        if (StringUtils.isBlank((CharSequence)suffix)) {
            suffix = "/";
        }
        return suffix;
    }

    protected BeanContext createContext(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        return new BeanContext.Servlet(this.getServletContext(), this.bundleContext, request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        BeanContext context = this.createContext(request, response);
        String pathInfo = request.getPathInfo();
        Matcher matcher = this.getPathPattern(context).matcher(pathInfo);
        if (matcher.matches()) {
            if (this.checkConsoleAccess(context)) {
                RequestDispatcherOptions options = new RequestDispatcherOptions();
                this.prepareForward(context, options);
                Resource resource = request.getResource();
                RequestDispatcher dispatcher = request.getRequestDispatcher(resource, options);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(LinkUtil.getUrl(request, this.getRequestPath(request)));
            }
        }
    }

    protected void prepareForward(BeanContext context, RequestDispatcherOptions options) {
        String path = this.getRequestPath(context.getRequest());
        if (StringUtils.isNotBlank((CharSequence)path)) {
            options.setReplaceSuffix(path);
        }
        String resourceType = this.getResourceType(context);
        options.setForceResourceType(resourceType);
    }

    protected boolean checkConsoleAccess(BeanContext context) {
        String consolePath = this.getConsolePath(context);
        if (StringUtils.isNotBlank((CharSequence)consolePath)) {
            return context.getResolver().getResource(consolePath) != null;
        }
        return true;
    }
}

