/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.script;

import com.composum.sling.core.concurrent.AbstractJobExecutor;
import com.composum.sling.core.script.GroovyRunner;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Groovy Job Executor Service", description="Provides the execution of groovy scripts in the repository context.", immediate=true, metatype=true)
@Service(value={JobExecutor.class, EventHandler.class})
@Properties(value={@Property(name="job.topics", value={"com/composum/sling/core/script/GroovyJobExecutor"}, propertyPrivate=true), @Property(name="event.topics", value={"org/apache/sling/event/notification/job/*"}, propertyPrivate=true)})
public class GroovyJobExecutor
extends AbstractJobExecutor<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyJobExecutor.class);
    static final String GROOVY_TOPIC = "com/composum/sling/core/script/GroovyJobExecutor";
    private static final String SCRIPT_PROPERTY_NAME = "reference";
    private static final String AUDIT_BASE_PATH = "/var/audit/jobs/com.composum.sling.core.script.GroovyJobExecutor";
    public static final String GROOVY_SETUP_SCRIPT = "groovy.setup.script";
    @Property(name="groovy.setup.script", label="Groovy setup script", description="the optional path to a custom groovy script to setup a groovy runner script object", value={""})
    protected String groovySetupScript;
    @Reference
    protected DynamicClassLoaderManager dynamicClassLoaderManager;

    @Override
    @Activate
    protected void activate(ComponentContext context) throws Exception {
        Dictionary properties = context.getProperties();
        this.groovySetupScript = PropertiesUtil.toString(properties.get(GROOVY_SETUP_SCRIPT), (String)"script/setup.groovy");
        if (StringUtils.isBlank((CharSequence)this.groovySetupScript)) {
            this.groovySetupScript = "script/setup.groovy";
        }
    }

    @Override
    protected String getJobTopic() {
        return GROOVY_TOPIC;
    }

    @Override
    protected String getAuditBasePath() {
        return AUDIT_BASE_PATH;
    }

    @Override
    protected boolean jobExecutionEnabled(Job job) {
        return !Boolean.getBoolean("composum.never.start.groovy");
    }

    @Override
    protected String buildAuditPathIntern(String reference, Calendar eventJobStartedTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
        if (reference.endsWith("/jcr:content")) {
            return this.getAuditBasePath() + reference.substring(0, reference.lastIndexOf(47)) + "/" + sdf.format(eventJobStartedTime.getTime());
        }
        return this.getAuditBasePath() + reference + "/" + sdf.format(eventJobStartedTime.getTime());
    }

    @Override
    protected Callable<Object> createCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws Exception {
        return new GroovyRunnerCallable(job, context, serviceResolver, out);
    }

    @Override
    protected void jobExecutionFinished(Job job, JobExecutionContext context, Resource auditResource) throws IOException {
        String scriptname;
        String scriptPath = (String)job.getProperty(SCRIPT_PROPERTY_NAME, String.class);
        ResourceResolver resourceResolver = auditResource.getResourceResolver();
        Resource scriptResource = resourceResolver.getResource(scriptPath);
        if (scriptPath.endsWith("/jcr:content")) {
            String substringWithoutContent = scriptPath.substring(0, scriptPath.lastIndexOf(47));
            scriptname = substringWithoutContent.substring(substringWithoutContent.lastIndexOf(47) + 1);
        } else {
            scriptname = scriptPath.substring(scriptPath.lastIndexOf(47) + 1);
        }
        Resource scriptAuditResource = resourceResolver.create(auditResource, scriptname, (Map)new HashMap<String, Object>(){
            {
                this.put("jcr:primaryType", "nt:file");
            }
        });
        try (final InputStream inputStream = (InputStream)scriptResource.adaptTo(InputStream.class);){
            resourceResolver.create(scriptAuditResource, "jcr:content", (Map)new HashMap<String, Object>(){
                {
                    this.put("jcr:primaryType", "nt:resource");
                    this.put("jcr:mimeType", "text/x-groovy");
                    this.put("jcr:data", inputStream);
                }
            });
        }
        resourceResolver.commit();
    }

    @Override
    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    @Override
    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected class GroovyRunnerCallable
    extends AbstractJobExecutor.UserContextCallable {
        GroovyRunnerCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws RepositoryException, LoginException {
            super(job, context, serviceResolver, out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(GroovyJobExecutor.this.dynamicClassLoaderManager.getDynamicClassLoader());
            GroovyRunner groovyRunner = new GroovyRunner(this.session, this.out, GroovyJobExecutor.this.groovySetupScript);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("jctx", this.context);
            variables.put("job", this.job);
            String reference = (String)this.job.getProperty(GroovyJobExecutor.SCRIPT_PROPERTY_NAME, String.class);
            String script = reference.endsWith("/jcr:content") ? reference.substring(0, reference.lastIndexOf(47)) : reference;
            try {
                Object object = groovyRunner.run(script, variables);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
                this.close();
            }
        }
    }
}

