/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.request;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.SlingBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public class DomIdentifiers {
    public static final String ATTRIBUTE_KEY = DomIdentifiers.class.getName();
    private Integer identifierCount = 0;
    private Map<String, Element> registeredElements = new HashMap<String, Element>();

    public static synchronized DomIdentifiers getInstance(BeanContext context) {
        SlingHttpServletRequest request = context.getRequest();
        DomIdentifiers manager = (DomIdentifiers)request.getAttribute(ATTRIBUTE_KEY);
        if (manager == null) {
            manager = new DomIdentifiers();
            request.setAttribute(ATTRIBUTE_KEY, (Object)manager);
        }
        return manager;
    }

    protected DomIdentifiers() {
    }

    private synchronized int nextId() {
        this.identifierCount = this.identifierCount + 1;
        return this.identifierCount;
    }

    public String getElementId(SlingBean bean) {
        return this.getElementId(bean.getPath(), bean.getType());
    }

    public String getElementId(Resource resource) {
        return this.getElementId(resource.getPath(), resource.getResourceType());
    }

    public String getElementId(String path, String type) {
        return this.getElement((String)path, (String)type).id;
    }

    public Element getElement(String path, String type) {
        Element element = this.registeredElements.get(path);
        if (element == null) {
            element = new Element(path, type);
            this.registeredElements.put(path, element);
        }
        return element;
    }

    public class Element {
        public final String id;
        public final String path;
        public final String type;

        public Element(String path, String type) {
            this.path = path;
            this.type = StringUtils.isNotBlank((CharSequence)type) ? type : "any";
            int idValue = DomIdentifiers.this.nextId();
            this.id = path.substring(path.lastIndexOf(47) + 1) + "-" + type.substring(type.lastIndexOf(47) + 1) + "-" + idValue;
        }
    }
}

