/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.mapping.json;

import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.jcr.StringFilterMapping;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFilterTypeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(StringFilterTypeAdapter.class);
    public static final GsonBuilder GSON_BUILDER = StringFilterTypeAdapter.registerTypeAdapters(new GsonBuilder());
    public static final Gson GSON = GSON_BUILDER.create();

    public static GsonBuilder registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter((Type)((Object)StringFilter.FilterSet.class), new FilterSetAdapter());
        builder.registerTypeAdapter((Type)((Object)StringFilter.WhiteList.class), new PatternListAdapter());
        builder.registerTypeAdapter((Type)((Object)StringFilter.BlackList.class), new PatternListAdapter());
        builder.registerTypeAdapter((Type)((Object)StringFilter.class), new GeneralAdapter());
        return builder;
    }

    public static class FilterSetAdapter
    extends GeneralAdapter {
        protected transient StringFilter.FilterSet.Rule rule = null;
        protected transient List<StringFilter> set = null;

        @Override
        protected void writeValues(JsonWriter writer, StringFilter value) throws IOException {
            super.writeValues(writer, value);
            writer.name(JsonValues.rule.name()).value(((StringFilter.FilterSet)value).getRule().name());
            writer.name(JsonValues.set.name());
            List<StringFilter> set = ((StringFilter.FilterSet)value).getSet();
            GSON.toJson(set, set.getClass(), writer);
        }

        @Override
        protected StringFilter createInstance(Class<? extends StringFilter> type) throws Exception {
            StringFilter result = type.getConstructor(StringFilter.FilterSet.Rule.class, List.class).newInstance(new Object[]{this.rule, this.set});
            return result;
        }

        @Override
        protected Object parseValue(JsonReader reader, String name) throws Exception {
            switch (JsonValues.valueOf(name)) {
                case rule: {
                    this.rule = StringFilter.FilterSet.Rule.valueOf(reader.nextString());
                    return this.rule;
                }
                case set: {
                    Gson gson = StringFilterTypeAdapter.registerTypeAdapters(new GsonBuilder()).create();
                    this.set = (List)gson.fromJson(reader, (Type)((Object)List.class));
                    return this.set;
                }
            }
            return super.parseValue(reader, name);
        }

        static enum JsonValues {
            type,
            rule,
            set;

        }
    }

    public static class PatternListAdapter
    extends GeneralAdapter {
        protected transient List<Pattern> patterns = null;

        @Override
        protected void writeValues(JsonWriter writer, StringFilter value) throws IOException {
            super.writeValues(writer, value);
            writer.name(JsonValues.patterns.name());
            List<Pattern> patterns = ((StringFilter.PatternList)value).getPatterns();
            writer.beginArray();
            for (Pattern pattern : patterns) {
                writer.value(pattern.pattern());
            }
            writer.endArray();
        }

        @Override
        protected StringFilter createInstance(Class<? extends StringFilter> type) throws Exception {
            StringFilter result = this.patterns != null ? type.getConstructor(List.class).newInstance(this.patterns) : super.createInstance(type);
            return result;
        }

        @Override
        protected Object parseValue(JsonReader reader, String name) throws Exception {
            switch (JsonValues.valueOf(name)) {
                case patterns: {
                    this.patterns = new ArrayList<Pattern>();
                    reader.beginArray();
                    while (reader.peek() != JsonToken.END_ARRAY) {
                        this.patterns.add(Pattern.compile(reader.nextString()));
                    }
                    reader.endArray();
                    return this.patterns;
                }
            }
            return super.parseValue(reader, name);
        }

        static enum JsonValues {
            type,
            patterns;

        }
    }

    public static class GeneralAdapter
    extends TypeAdapter<StringFilter> {
        protected transient Class<? extends StringFilter> type = null;
        protected transient GeneralAdapter delegate = null;

        protected void writeValues(JsonWriter writer, StringFilter value) throws IOException {
            String typeName = StringFilterMapping.getTypeName(value);
            writer.name(JsonValues.type.name()).value(typeName);
        }

        @Override
        public void write(JsonWriter writer, StringFilter value) throws IOException {
            writer.beginObject();
            this.writeValues(writer, value);
            writer.endObject();
        }

        protected StringFilter createInstance(Class<? extends StringFilter> type) throws Exception {
            StringFilter result = StringFilter.All.class.equals(type) ? StringFilter.ALL : type.newInstance();
            return result;
        }

        protected Object parseValue(JsonReader reader, String name) throws Exception {
            switch (JsonValues.valueOf(name)) {
                case type: {
                    TypeAdapter<? extends StringFilter> adapter;
                    this.type = StringFilterMapping.getType(reader.nextString());
                    if (this.type != null && (adapter = GSON.getAdapter(this.type)) instanceof GeneralAdapter) {
                        this.delegate = (GeneralAdapter)adapter;
                    }
                    return this.type;
                }
            }
            return null;
        }

        @Override
        public StringFilter read(JsonReader reader) throws IOException {
            StringFilter result = null;
            this.type = null;
            this.delegate = null;
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                try {
                    if (this.delegate != null) {
                        this.delegate.parseValue(reader, name);
                        continue;
                    }
                    this.parseValue(reader, name);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    throw new IOException(ex);
                }
            }
            reader.endObject();
            if (this.type != null) {
                try {
                    result = this.delegate != null ? this.delegate.createInstance(this.type) : this.createInstance(this.type);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    throw new IOException(ex.toString());
                }
            }
            return result;
        }

        static enum JsonValues {
            type;

        }
    }
}

