/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.mapping;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.servlet.NodeTreeServlet;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingRules {
    private static final Logger LOG = LoggerFactory.getLogger(MappingRules.class);
    public static final String CONTENT_NODE_FILE_NAME = "_content";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String MAP_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    public static final String[] DATE_PATTERNS = new String[]{"EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "EEE MMM dd yyyy HH:mm:ss z", "EEE MMM dd yyyy HH:mm:ss Z", "EEE MMM dd yyyy HH:mm:ss X", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss Z", "yyyy-MM-dd HH:mm:ss X", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yy-MM-dd", "dd.MM.yyyy HH:mm:ss 'GMT'Z", "dd.MM.yyyy HH:mm:ss z", "dd.MM.yyyy HH:mm:ss Z", "dd.MM.yyyy HH:mm:ss X", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy HH:mm", "dd.MM.yyyy", "dd.MM.yy"};
    public static final Pattern TYPED_PROPERTY_STRING = Pattern.compile("^\\{([A-Za-z]+)}(.*)$");
    public static final String PROPERTIES_NAME = "_properties_";
    public static final String CHILD_ORDER_NAME = "_child_order_";
    public static final ResourceFilter DEFAULT_NODE_FILTER = new ResourceFilter.FilterSet(ResourceFilter.FilterSet.Rule.and, new ResourceFilter.NameFilter(new StringFilter.BlackList("^rep:(repo)?[Pp]olicy$")), new ResourceFilter.PathFilter(new StringFilter.BlackList("^/system(/.*)$", "^/services(/.*)$", "^/bin(/.*)$")));
    public static final NodeTreeServlet.TreeNodeStrategy DEFAULT_TREE_NODE_STRATEGY = new NodeTreeServlet.DefaultTreeNodeStrategy(DEFAULT_NODE_FILTER);
    public static final ResourceFilter MAPPING_NODE_FILTER = new ResourceFilter.PathFilter(new StringFilter.BlackList("^/system", "^/services", "^/bin"));
    public static final StringFilter MAPPING_EXPORT_FILTER = StringFilter.ALL;
    public static final StringFilter SOURCE_EXPORT_FILTER = new StringFilter.BlackList("^jcr:(created|lastModified)(By)?$", "^jcr:(uuid|baseVersion|predecessors|versionHistory|isCheckedOut)$");
    public static final StringFilter MAPPING_IMPORT_FILTER = new StringFilter.BlackList("jcr:created", "jcr:createdBy", "jcr:uuid");
    public final ResourceFilter resourceFilter;
    public final StringFilter exportPropertyFilter;
    public final StringFilter importPropertyFilter;
    public final PropertyFormat propertyFormat;
    public final int maxDepth;
    public final ChangeRule changeRule;
    public final DateParser dateParser;

    public MappingRules(ResourceFilter resourceFilter, StringFilter exportPropertyFilter, StringFilter importPropertyFilter, PropertyFormat propertyFormat, Integer maxDepth, ChangeRule changeRule) {
        this.resourceFilter = resourceFilter;
        this.exportPropertyFilter = exportPropertyFilter;
        this.importPropertyFilter = importPropertyFilter;
        this.propertyFormat = propertyFormat;
        this.maxDepth = maxDepth;
        this.changeRule = changeRule;
        this.dateParser = new DateParser();
    }

    public MappingRules(MappingRules template, ResourceFilter resourceFilter, StringFilter exportPropertyFilter, StringFilter importPropertyFilter, PropertyFormat propertyFormat, Integer maxDepth, ChangeRule changeRule) {
        this.resourceFilter = resourceFilter != null ? resourceFilter : template.resourceFilter;
        this.exportPropertyFilter = exportPropertyFilter != null ? exportPropertyFilter : template.exportPropertyFilter;
        this.importPropertyFilter = importPropertyFilter != null ? importPropertyFilter : template.importPropertyFilter;
        this.propertyFormat = propertyFormat != null ? propertyFormat : template.propertyFormat;
        this.maxDepth = maxDepth != null ? maxDepth : template.maxDepth;
        this.changeRule = changeRule != null ? changeRule : template.changeRule;
        this.dateParser = new DateParser();
    }

    public static MappingRules getDefaultMappingRules() {
        return new MappingRules(MAPPING_NODE_FILTER, MAPPING_EXPORT_FILTER, MAPPING_IMPORT_FILTER, new PropertyFormat(PropertyFormat.Scope.value, PropertyFormat.Binary.base64), 0, ChangeRule.update);
    }

    public static class DateParser {
        protected List<SimpleDateFormat> formatList = new ArrayList<SimpleDateFormat>();

        public DateParser() {
            this(Arrays.asList(DATE_PATTERNS));
        }

        public DateParser(Iterable<String> datePatterns) {
            for (String pattern : datePatterns) {
                try {
                    this.formatList.add(new SimpleDateFormat(pattern));
                }
                catch (Throwable t) {
                    LOG.warn("Date format '" + pattern + "' igonred (" + t.toString() + ")");
                }
            }
        }

        public Date parse(String string) {
            Date date = null;
            if (StringUtils.isNotBlank((CharSequence)string)) {
                for (SimpleDateFormat dateFormat : this.formatList) {
                    try {
                        date = dateFormat.parse(string);
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
            return date;
        }
    }

    public static enum ChangeRule {
        skip,
        extend,
        merge,
        update;

    }

    public static class PropertyFormat {
        public final Scope scope;
        public final boolean embedType;
        public final Binary binary;

        public PropertyFormat(Scope scope, Binary binary) {
            this(scope, binary, true);
        }

        public PropertyFormat(Scope scope, Binary binary, boolean embedType) {
            this.scope = scope != null ? scope : Scope.value;
            this.binary = binary != null ? binary : Binary.base64;
            this.embedType = embedType;
        }

        public static enum Binary {
            skip,
            link,
            base64;

        }

        public static enum Scope {
            value,
            object,
            definition;

        }
    }

    public static enum ContentNodeType {
        json,
        xml;

    }
}

