/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.filter;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.NodeTypeFilters;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import com.composum.sling.core.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ResourceFilter {
    public static final Logger LOG = LoggerFactory.getLogger(ResourceFilter.class);
    public static final Pattern SIMPLE_ARRAY_PATTERN = Pattern.compile("^([+-])\\[(.*)\\]$");
    public static final ResourceFilter ALL = new AllFilter();
    public static final ResourceFilter FOLDER = new FolderFilter();

    public boolean accept(Resource var1);

    public boolean isRestriction();

    public void toString(StringBuilder var1);

    public static class FilterSet
    implements ResourceFilter {
        protected final Rule rule;
        protected final List<ResourceFilter> set;
        protected transient Boolean restriction;

        public FilterSet(Rule rule, ResourceFilter ... filters) {
            this.rule = rule;
            this.set = new ArrayList<ResourceFilter>();
            Collections.addAll(this.set, filters);
        }

        public FilterSet(Rule rule, List<ResourceFilter> filters) {
            this.rule = rule;
            this.set = filters;
        }

        public FilterSet(Rule rule, String ... filters) {
            this.rule = rule;
            this.set = new ArrayList<ResourceFilter>();
            for (String string : filters) {
                ResourceFilter filter = ResourceFilterMapping.fromString(string);
                if (ALL.equals(filter)) continue;
                this.set.add(filter);
            }
        }

        public Rule getRule() {
            return this.rule;
        }

        public List<ResourceFilter> getSet() {
            return this.set;
        }

        public boolean isIntermediate(Resource resource) {
            return this.rule == Rule.tree && this.set.size() > 0 && !this.set.get(0).accept(resource);
        }

        @Override
        public boolean accept(Resource resource) {
            switch (this.rule) {
                case tree: 
                case or: {
                    for (ResourceFilter filter : this.set) {
                        if (!filter.accept(resource)) continue;
                        return true;
                    }
                    return this.set.size() == 0;
                }
                case and: {
                    for (ResourceFilter filter : this.set) {
                        if (filter.accept(resource)) continue;
                        return false;
                    }
                    return this.set.size() > 0;
                }
                case first: {
                    for (ResourceFilter filter : this.set) {
                        if (filter.accept(resource) && !filter.isRestriction()) {
                            return true;
                        }
                        if (filter.accept(resource) || !filter.isRestriction()) continue;
                        return false;
                    }
                    return false;
                }
                case last: {
                    boolean result = false;
                    for (ResourceFilter filter : this.set) {
                        if (filter.accept(resource) && !filter.isRestriction()) {
                            result = true;
                        }
                        if (filter.accept(resource) || !filter.isRestriction()) continue;
                        result = false;
                    }
                    return result;
                }
            }
            return this.isRestriction();
        }

        @Override
        public boolean isRestriction() {
            if (this.restriction == null) {
                block0 : switch (this.rule) {
                    case or: 
                    case last: {
                        this.restriction = true;
                        for (ResourceFilter filter : this.set) {
                            if (filter.isRestriction()) continue;
                            this.restriction = false;
                            break block0;
                        }
                        break;
                    }
                    case and: 
                    case first: {
                        this.restriction = false;
                        for (ResourceFilter filter : this.set) {
                            if (!filter.isRestriction()) continue;
                            this.restriction = true;
                            break block0;
                        }
                        break;
                    }
                    case tree: {
                        this.restriction = this.set.size() > 0 ? this.set.get(0).isRestriction() : true;
                    }
                }
            }
            return this.restriction;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append(this.rule.name());
            builder.append("{");
            int i = 0;
            while (i < this.set.size()) {
                this.set.get(i).toString(builder);
                if (++i >= this.set.size()) continue;
                builder.append(',');
            }
            builder.append("}");
        }

        public static enum Rule {
            and,
            or,
            first,
            last,
            tree;

        }
    }

    public static class MimeTypeFilter
    extends PatternFilter {
        public MimeTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            if (resource != null) {
                ResourceHandle handle = ResourceHandle.use(resource);
                String mimeType = handle.getProperty("jcr:mimeType");
                if (StringUtils.isNotBlank((CharSequence)mimeType)) {
                    return this.filter.accept(mimeType);
                }
                Resource content = handle.getChild("jcr:content");
                return this.accept(content);
            }
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("MimeType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class ResourceTypeFilter
    extends PatternFilter {
        public ResourceTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            if (resource != null) {
                String type = resource.getResourceType();
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    return this.accept(type);
                }
                Resource content = resource.getChild("jcr:content");
                return this.accept(content);
            }
            return false;
        }

        protected boolean accept(String resourceType) {
            return StringUtils.isNotBlank((CharSequence)resourceType) && this.filter.accept(resourceType);
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("ResourceType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class MixinTypeFilter
    extends PatternFilter {
        public MixinTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            Node node;
            if (resource != null && (node = (Node)resource.adaptTo(Node.class)) != null) {
                try {
                    NodeType[] mixinTypes = node.getMixinNodeTypes();
                    if (this.filter.isRestriction()) {
                        for (NodeType mixinType : mixinTypes) {
                            if (this.filter.accept(mixinType.getName())) continue;
                            return false;
                        }
                        return true;
                    }
                    for (NodeType mixinType : mixinTypes) {
                        if (!this.filter.accept(mixinType.getName())) continue;
                        return true;
                    }
                    return false;
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("MixinType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class PrimaryTypeFilter
    extends PatternFilter {
        public PrimaryTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            String primaryType = ResourceUtil.getPrimaryType(resource);
            if (StringUtils.isNotBlank((CharSequence)primaryType)) {
                return this.filter.accept(primaryType);
            }
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("PrimaryType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class PathFilter
    extends PatternFilter {
        public PathFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            return resource != null ? this.filter.accept(resource.getPath()) : false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("Path(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class NameFilter
    extends PatternFilter {
        public NameFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            return resource != null ? this.filter.accept(resource.getName()) : false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("Name(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static abstract class PatternFilter
    implements ResourceFilter {
        protected StringFilter filter;

        public StringFilter getFilter() {
            return this.filter;
        }

        @Override
        public boolean isRestriction() {
            return this.filter.isRestriction();
        }

        @Override
        public void toString(StringBuilder builder) {
            this.filter.toString(builder);
        }
    }

    public static class TypeFilter
    implements ResourceFilter {
        protected List<String> typeNames;
        protected boolean restriction = false;

        public List<String> getTypeNames() {
            return this.typeNames;
        }

        public TypeFilter(String names) {
            Matcher matcher = SIMPLE_ARRAY_PATTERN.matcher(names);
            if (matcher.matches()) {
                this.restriction = "-".equals(matcher.group(1));
                names = matcher.group(2);
            }
            this.typeNames = Arrays.asList(StringUtils.split((String)names, (String)","));
        }

        public TypeFilter(List<String> names, boolean restriction) {
            this.typeNames = names;
            this.restriction = restriction;
        }

        @Override
        public boolean accept(Resource resource) {
            for (String type : this.typeNames) {
                if (!(type.startsWith("node:") ? NodeTypeFilters.accept(resource, type) : resource.isResourceType(type))) continue;
                return !this.restriction;
            }
            return this.restriction;
        }

        @Override
        public boolean isRestriction() {
            return this.restriction;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append(this.restriction ? (char)'-' : '+');
            builder.append('[');
            builder.append(StringUtils.join(this.typeNames, (String)","));
            builder.append(']');
        }
    }

    public static class FolderFilter
    extends PrimaryTypeFilter {
        public FolderFilter() {
            super(new StringFilter.WhiteList("^(sling|nt):.*[Ff]older$"));
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("Folder()");
        }
    }

    public static final class AllFilter
    implements ResourceFilter {
        @Override
        public boolean accept(Resource resource) {
            return resource != null;
        }

        @Override
        public boolean isRestriction() {
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("All()");
        }
    }
}

