/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.event;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChangeObserver
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractChangeObserver.class);
    public static final int EVENT_TYPES = 63;
    public static final String PROP_LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    public static final String LOG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final StringFilter PROPERTY_PATH_FILTER = new StringFilter.FilterSet(StringFilter.FilterSet.Rule.or, new StringFilter.BlackList("/(jcr|sling):[^/]*$"), new StringFilter.WhiteList("/jcr:(title|description|data)[^/]*$"));
    protected BundleContext bundleContext;

    protected abstract String getServiceUserId();

    protected abstract String getObservedPath();

    protected abstract void doOnChange(ResourceResolver var1, ChangedResource var2) throws RepositoryException, PersistenceException;

    protected abstract boolean isTargetNode(Node var1) throws RepositoryException;

    protected String getTargetPath(Node node) throws RepositoryException {
        String path = node.getPath();
        return "/".equals(path) ? null : path;
    }

    protected StringFilter getPropertyPathFilter() {
        return PROPERTY_PATH_FILTER;
    }

    protected StringFilter getNodePathFilter() {
        return StringFilter.ALL;
    }

    protected ResourceFilter getResourceFilter() {
        return ResourceFilter.ALL;
    }

    protected abstract ResourceResolver getResolver() throws LoginException;

    protected abstract Session getSession() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        block15: {
            try {
                ResourceResolver resolver = this.getResolver();
                if (resolver == null) break block15;
                try {
                    Session session = (Session)resolver.adaptTo(Session.class);
                    String serviceUserId = this.getServiceUserId();
                    ChangeCollection changedNodes = new ChangeCollection();
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        try {
                            String path = event.getPath();
                            String user = event.getUserID();
                            if (serviceUserId.equals(user)) continue;
                            Calendar time = Calendar.getInstance();
                            time.setTime(new Date(event.getDate()));
                            int type = event.getType();
                            if (this.isPropertyEvent(type)) {
                                if (!this.getPropertyPathFilter().accept(path)) continue;
                                changedNodes.registerChange(session, resolver, path, time, user);
                                continue;
                            }
                            if (!this.getNodePathFilter().accept(path)) continue;
                            changedNodes.registerChange(session, resolver, path, time, user);
                        }
                        catch (RepositoryException rex) {
                            LOG.error(rex.getMessage(), (Throwable)rex);
                        }
                    }
                    if (changedNodes.size() > 0) {
                        for (ChangedResource change : changedNodes.values()) {
                            try {
                                this.doOnChange(resolver, change);
                            }
                            catch (RepositoryException ex) {
                                LOG.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        changedNodes.clear();
                        resolver.commit();
                    }
                }
                catch (PersistenceException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    resolver.close();
                }
            }
            catch (LoginException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected Node getContentNode(Session session, String path) throws RepositoryException {
        Node node = null;
        try {
            Item item = session.getItem(path);
            for (node = item.isNode() ? (Node)item : item.getParent(); node != null && !this.isTargetNode(node) && (path = this.getTargetPath(node)) != null; node = node.getParent()) {
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return path != null ? node : null;
    }

    protected boolean isPropertyEvent(int type) {
        return (type & 0x1C) != 0;
    }

    @Activate
    @Modified
    protected void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        try {
            Session session = this.getSession();
            session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 63, this.getObservedPath(), true, null, null, true);
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Deactivate
    protected void deactivate() {
        try {
            Session session = this.getSession();
            session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected class ChangedResource {
        protected final Resource resource;
        protected Calendar time;
        protected String user;

        public ChangedResource(Resource resource, Calendar time, String user) {
            this.resource = resource;
            this.time = time;
            this.user = user;
        }

        public void mergeChange(Calendar time, String user) {
            if (time.after(this.time)) {
                this.time = time;
                this.user = user;
            }
        }

        public Resource getResource() {
            return this.resource;
        }

        public Calendar getTime() {
            return this.time;
        }

        public String getUser() {
            return this.user;
        }
    }

    protected class ChangeCollection
    extends HashMap<String, ChangedResource> {
        protected ChangeCollection() {
        }

        public void registerChange(Session session, ResourceResolver resolver, String path, Calendar time, String user) throws RepositoryException, LoginException {
            Node contentNode = AbstractChangeObserver.this.getContentNode(session, path);
            if (contentNode != null) {
                path = contentNode.getPath();
                ChangedResource change = (ChangedResource)this.get(path);
                if (change != null) {
                    change.mergeChange(time, user);
                } else {
                    Resource resource;
                    if (LOG.isDebugEnabled()) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(AbstractChangeObserver.LOG_DATE_FORMAT);
                        LOG.debug("registered: " + path + ", " + dateFormat.format(time.getTime()) + ", " + user);
                    }
                    if ((resource = resolver.getResource(path)) != null && AbstractChangeObserver.this.getResourceFilter().accept(resource)) {
                        this.put(path, new ChangedResource(resource, time, user));
                    }
                }
            }
        }
    }
}

