/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import com.composum.sling.core.concurrent.SequencerService;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false)
@Service
public class SemaphoreSequencer
implements SequencerService<Token> {
    private static final Logger LOG = LoggerFactory.getLogger(SemaphoreSequencer.class);
    HashMap<String, Semaphore> semaphores;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token acquire(String key) {
        Semaphore semaphore;
        SemaphoreSequencer semaphoreSequencer = this;
        synchronized (semaphoreSequencer) {
            semaphore = this.semaphores.get(key);
            if (semaphore == null) {
                semaphore = new Semaphore(1);
                this.semaphores.put(key, semaphore);
            }
        }
        try {
            LOG.debug("acquire (" + key + ")");
            semaphore.acquire();
        }
        catch (InterruptedException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            semaphore.release();
        }
        return new Token(key, semaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Token token) {
        if (token != null) {
            LOG.debug("release (" + token.key + ")");
            token.semaphore.release();
            SemaphoreSequencer semaphoreSequencer = this;
            synchronized (semaphoreSequencer) {
                if (!token.semaphore.hasQueuedThreads()) {
                    this.semaphores.remove(token.key);
                }
            }
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.semaphores = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        SemaphoreSequencer semaphoreSequencer = this;
        synchronized (semaphoreSequencer) {
            if (this.semaphores != null) {
                for (Semaphore semaphore : this.semaphores.values()) {
                    while (semaphore.hasQueuedThreads()) {
                        semaphore.release();
                    }
                }
                this.semaphores.clear();
                this.semaphores = null;
            }
        }
    }

    public static final class Token
    implements SequencerService.Token {
        protected final String key;
        protected final Semaphore semaphore;

        protected Token(String key, Semaphore semaphore) {
            this.key = key;
            this.semaphore = semaphore;
        }
    }
}

