/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.concurrent.LazyCreationService;
import com.composum.sling.core.concurrent.SequencerService;
import com.composum.sling.core.util.ResourceUtil;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Composum lazy creation service", description="provides a cluster-safe 'get or create' pattern", immediate=true, metatype=true)
@Service
public class LazyCreationServiceImpl
implements LazyCreationService {
    private static final Logger LOG = LoggerFactory.getLogger(LazyCreationServiceImpl.class);
    public static final String MAXIMUM_LOCKWAIT_TIME_SEC = "lazycreation.maximumlockwait";
    @Property(name="lazycreation.maximumlockwait", label="Maximum lock wait time", description="Maximum time in seconds for which the service waits until it assumes another cluster node tried to create a resource and the attempt hangs. The lock is broken after that and another attempt is started.", intValue={30})
    protected int maximumLockWaitTimeSec;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference
    protected SequencerService sequencer;

    @Override
    public <T> T getOrCreate(ResourceResolver resolver, String path, LazyCreationService.RetrievalStrategy<T> getter, LazyCreationService.CreationStrategy creator, final Map<String, Object> parentProperties) throws RepositoryException {
        LazyCreationService.ParentCreationStrategy parentCreationStrategy = new LazyCreationService.ParentCreationStrategy(){

            @Override
            public Resource createParent(ResourceResolver resolver, Resource parentsParent, String parentName, int level) throws RepositoryException, PersistenceException {
                return resolver.create(parentsParent, parentName, parentProperties);
            }
        };
        return this.getOrCreate(resolver, path, getter, creator, parentCreationStrategy);
    }

    @Override
    public <T> T getOrCreate(ResourceResolver resolver, String path, LazyCreationService.RetrievalStrategy<T> getter, LazyCreationService.CreationStrategy creator, LazyCreationService.InitializationStrategy initializer, final Map<String, Object> parentProperties) throws RepositoryException, PersistenceException {
        LazyCreationService.ParentCreationStrategy parentCreationStrategy = new LazyCreationService.ParentCreationStrategy(){

            @Override
            public Resource createParent(ResourceResolver resolver, Resource parentsParent, String parentName, int level) throws RepositoryException, PersistenceException {
                return resolver.create(parentsParent, parentName, parentProperties);
            }
        };
        return this.getOrCreate(resolver, path, getter, creator, initializer, parentCreationStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOrCreate(ResourceResolver resolver, String path, LazyCreationService.RetrievalStrategy<T> getter, LazyCreationService.CreationStrategy creator, LazyCreationService.ParentCreationStrategy parentCreationStrategy) throws RepositoryException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)path.startsWith("/"), (String)"Path must be absolute: %s", (Object[])new Object[]{path});
        T result = getter.get(resolver, path);
        if (null != result) {
            return result;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        ResourceResolver adminResolver = null;
        Object token = this.sequencer.acquire(path);
        try {
            this.refreshSession(resolver, true);
            result = getter.get(resolver, path);
            if (null != result) {
                T t = result;
                return t;
            }
            adminResolver = this.createAdministrativeResolver();
            Resource parentResource = adminResolver.getResource(parentPath);
            if (null == parentResource) {
                this.sequencer.release(token);
                token = null;
                parentResource = this.safeCreateParent(adminResolver, parentPath, 1, parentCreationStrategy);
                Validate.notNull((Object)parentResource, (String)("Parent creator didn't create " + parentPath), (Object[])new Object[0]);
                token = this.sequencer.acquire(path);
                this.refreshSession(resolver, true);
                result = getter.get(resolver, path);
                if (null != result) {
                    T t = result;
                    return t;
                }
            }
            try {
                this.refreshSession(adminResolver, false);
                creator.create(adminResolver, parentResource, ResourceUtil.getName((String)path));
                adminResolver.commit();
                Resource resourceAsAdmin = adminResolver.getResource(path);
                Validate.notNull((Object)resourceAsAdmin, (String)"Bug: could not find %s even after calling creator", (Object[])new Object[]{path});
                LOG.debug("Created {}", (Object)path);
            }
            catch (ItemExistsException | PersistenceException e) {
                LOG.info("Creation of {} aborted - probably parallel creation {}", (Object)path, (Object)(e.toString() + "/" + String.valueOf(e.getCause())));
            }
            catch (RepositoryException e) {
                LOG.warn("Creation error for {}: {}", (Object)path, (Object)e);
            }
            this.refreshSession(resolver, true);
            result = getter.get(resolver, path);
        }
        finally {
            if (null != token) {
                this.sequencer.release(token);
            }
            if (null != adminResolver) {
                adminResolver.close();
            }
        }
        if (null == result) {
            LOG.warn("Still not present after trying to create it: {}", (Object)path);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOrCreate(ResourceResolver resolver, String path, LazyCreationService.RetrievalStrategy<T> getter, LazyCreationService.CreationStrategy creator, LazyCreationService.InitializationStrategy initializer, LazyCreationService.ParentCreationStrategy parentCreationStrategy) throws RepositoryException, PersistenceException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)path.startsWith("/"), (String)"Path must be absolute: %s", (Object[])new Object[]{path});
        if (this.resourceIsInitialized(resolver, path)) {
            return getter.get(resolver, path);
        }
        LOG.debug("Going to create and init {}", (Object)path);
        String parentPath = ResourceUtil.getParent((String)path);
        ResourceResolver adminResolver = null;
        Lock lock = null;
        try {
            this.refreshSession(resolver, true);
            if (this.resourceIsInitialized(resolver, path)) {
                T t = getter.get(resolver, path);
                return t;
            }
            adminResolver = this.createAdministrativeResolver();
            Resource parentResource = adminResolver.getResource(parentPath);
            if (null == parentResource) {
                parentResource = this.safeCreateParent(adminResolver, parentPath, 1, parentCreationStrategy);
                Validate.notNull((Object)parentResource, (String)("Parent creator didn't create " + parentPath), (Object[])new Object[0]);
            }
            this.refreshSession(adminResolver, false);
            Resource resource = adminResolver.getResource(path);
            if (null == resource) {
                resource = this.createUninitializedResource(adminResolver, parentResource, path, creator);
            }
            LockManager lockManager = ((Session)adminResolver.adaptTo(Session.class)).getWorkspace().getLockManager();
            lock = this.tryToLockResource(path, adminResolver);
            if (null != lock) {
                this.initializeResource(adminResolver, path, initializer, lockManager);
            }
            this.refreshSession(resolver, true);
            T result = getter.get(resolver, path);
            if (null == result) {
                LOG.warn("Still not present after trying to create it: {}", (Object)path);
            }
            T t = result;
            return t;
        }
        finally {
            if (null != adminResolver) {
                adminResolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createUninitializedResource(ResourceResolver adminResolver, Resource parentResource, String path, LazyCreationService.CreationStrategy creator) {
        Object token = this.sequencer.acquire(path);
        try {
            this.refreshSession(adminResolver, false);
            Resource resource = adminResolver.getResource(path);
            if (null == resource) {
                try {
                    resource = creator.create(adminResolver, parentResource, ResourceUtil.getName((String)path));
                    Node node = (Node)resource.adaptTo(Node.class);
                    node.addMixin("mix:created");
                    node.addMixin("mix:lastModified");
                    node.addMixin("mix:lockable");
                    node.setProperty("jcr:lastModified", (Value)null);
                    adminResolver.commit();
                    LOG.debug("Created uninitialized {}", (Object)path);
                }
                catch (ItemExistsException | PersistenceException e) {
                    LOG.info("Creation of uninitialized {} aborted - probably parallel creation: {}", (Object)path, (Object)(e.toString() + "/" + String.valueOf(e.getCause())));
                }
                catch (RepositoryException e) {
                    LOG.warn("Creation error for uninitialized {}: {}", (Object)path, (Object)e);
                }
                resource = adminResolver.getResource(path);
                Validate.notNull((Object)resource, (String)"Bug: could not find %s after trying to create it: %s", (Object[])new Object[]{path});
            }
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            this.sequencer.release(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Lock tryToLockResource(String path, ResourceResolver adminResolver) throws RepositoryException, PersistenceException {
        lockManager = ((Session)adminResolver.adaptTo(Session.class)).getWorkspace().getLockManager();
        resourceLockTime = ResourceHandle.use(adminResolver.getResource(path)).getProperty("jcr:lastModified", Calendar.getInstance());
        lockTime = Math.max(resourceLockTime.getTimeInMillis(), System.currentTimeMillis());
        stopPollingTime = lockTime + (long)(this.maximumLockWaitTimeSec * 1000);
        waitStep = 0L;
        lastFail = null;
        do {
            block22: {
                try {
                    Thread.sleep(waitStep);
                }
                catch (InterruptedException var14_11) {
                    // empty catch block
                }
                token = this.sequencer.acquire(path);
                try {
                    this.refreshSession(adminResolver, false);
                    if (this.resourceIsInitialized(adminResolver, path)) {
                        var15_13 = null;
                        return var15_13;
                    }
                    locked = lockManager.holdsLock(path);
                    LazyCreationServiceImpl.LOG.debug("Path {} is locked={}", (Object)path, (Object)locked);
                    if (locked) break block22;
                    try {
                        lock = lockManager.lock(path, true, false, 0x7FFFFFFFFFFFFFFFL, null);
                        ResourceHandle.use(adminResolver.getResource(path)).setProperty("jcr:lastModified", Calendar.getInstance());
                        adminResolver.commit();
                        LazyCreationServiceImpl.LOG.debug("Got lock on {} token {}", (Object)path, (Object)lock.getLockToken());
                        var17_20 = lock;
                        return var17_20;
                    }
                    catch (LockException | PersistenceException ex) {
                        LazyCreationServiceImpl.LOG.info("Could not lock {} : {}", (Object)path, (Object)ex.toString());
                        lastFail = ex;
                    }
                }
                finally {
                    this.sequencer.release(token);
                }
            }
            restWait = stopPollingTime - System.currentTimeMillis();
            waitStep = Math.min(waitStep * 2L + 100L, restWait);
        } while (restWait > 0L);
        token = this.sequencer.acquire(path);
        this.refreshSession(adminResolver, false);
        try {
            lock = lockManager.getLock(path);
        }
        catch (LockException le) {
            this.refreshSession(adminResolver, false);
            if (this.resourceIsInitialized(adminResolver, path)) {
                var17_21 = null;
                this.sequencer.release(token);
                return var17_21;
            }
            LazyCreationServiceImpl.LOG.error("Bug: could not lock " + path + " but is now unlocked but not ready: ", lastFail);
            throw new LockException("Could not lock " + path + " but is unlocked but not ready", lastFail);
        }
        ** try [egrp 8[TRYBLOCK] [8 : 462->621)] { 
lbl-1000:
        // 1 sources

        {
            ResourceHandle.use(adminResolver.getResource(path)).setProperty("jcr:lastModified", (Calendar)null);
            Validate.isTrue((boolean)path.equals(lock.getNode().getPath()), (String)"Unexpected lock path %s instead of %s", (Object[])new Object[]{path, lock.getNode().getPath()});
            adminResolver.commit();
            this.refreshSession(adminResolver, false);
            lockManager.addLockToken(lock.getLockToken());
            lockManager.unlock(path);
            lock = lockManager.lock(path, true, false, 0x7FFFFFFFFFFFFFFFL, null);
            adminResolver.commit();
            ResourceHandle.use(adminResolver.getResource(path)).setProperty("jcr:lastModified", Calendar.getInstance());
            adminResolver.commit();
            LazyCreationServiceImpl.LOG.info("Took over obsolete lock on {}", (Object)path);
            le = lock;
            return le;
        }
lbl71:
        // 1 sources

        catch (LockException le) {
            block23: {
                this.refreshSession(adminResolver, false);
                if (!this.resourceIsInitialized(adminResolver, path)) break block23;
                var17_22 = null;
                this.sequencer.release(token);
                return var17_22;
            }
            LazyCreationServiceImpl.LOG.warn("Taking over lock on " + path + " failed; giving up since timeout");
            throw le;
        }
        finally {
            this.sequencer.release(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeResource(ResourceResolver adminResolver, String path, LazyCreationService.InitializationStrategy initializer, LockManager lockManager) {
        Object token = this.sequencer.acquire(path);
        try {
            try {
                this.refreshSession(adminResolver, false);
                Resource resource = adminResolver.getResource(path);
                if (!this.resourceIsInitialized(adminResolver, path)) {
                    initializer.initialize(adminResolver, resource);
                    ResourceHandle.use(resource).setProperty("jcr:lastModified", Calendar.getInstance());
                    adminResolver.commit();
                }
                LOG.info("Initialized {}", (Object)path);
                this.refreshSession(adminResolver, false);
                if (lockManager.holdsLock(path)) {
                    lockManager.addLockToken(lockManager.getLock(path).getLockToken());
                    lockManager.unlock(path);
                    LOG.debug("Unlocking {}", (Object)path);
                }
                adminResolver.commit();
            }
            catch (ItemExistsException | PersistenceException e) {
                LOG.info("Initialization of {} aborted - probably parallel initialization: {}", (Object)path, (Object)(e.toString() + "/" + String.valueOf(e.getCause())));
            }
            catch (RepositoryException e) {
                LOG.warn("Initialization error for {}: {}", (Object)path, (Object)e);
            }
        }
        finally {
            this.sequencer.release(token);
        }
    }

    protected boolean resourceIsInitialized(ResourceResolver resolver, String path) throws RepositoryException {
        return this.isInitialized(resolver.getResource(path));
    }

    @Override
    public boolean isInitialized(Resource resource) throws RepositoryException {
        ResourceHandle handle = ResourceHandle.use(resource);
        return handle.isValid() && null != handle.getProperty("jcr:lastModified") && !((Session)handle.getResourceResolver().adaptTo(Session.class)).getWorkspace().getLockManager().holdsLock(handle.getPath());
    }

    @Override
    public Resource waitForInitialization(ResourceResolver resolver, String path) throws RepositoryException {
        long restWait;
        Resource resource = resolver.getResource(path);
        if (null == resource) {
            Object token = this.sequencer.acquire(path);
            this.sequencer.release(token);
            this.refreshSession(resolver, true);
            resource = resolver.getResource(path);
        }
        if (null == resource) {
            return null;
        }
        if (this.isInitialized(resource)) {
            return resource;
        }
        long stopPollingTime = System.currentTimeMillis() + (long)(this.maximumLockWaitTimeSec * 1000);
        long waitStep = 0L;
        do {
            try {
                Thread.sleep(waitStep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.refreshSession(resolver, true);
            resource = resolver.getResource(path);
            if (null == resource) {
                LOG.warn("Resource unexpectedly vanished during wait: {}", (Object)path);
                return null;
            }
            if (this.isInitialized(resource)) {
                return resource;
            }
            restWait = stopPollingTime - System.currentTimeMillis();
            waitStep = Math.min(waitStep * 2L + 100L, restWait);
        } while (restWait > 0L);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource safeCreateParent(ResourceResolver adminResolver, String path, int level, LazyCreationService.ParentCreationStrategy parentCreationStrategy) throws RepositoryException {
        String[] separated = ResourceUtil.splitPathAndName(path);
        String parentPath = "".equals(separated[0]) ? "/" : separated[0];
        Object token = this.sequencer.acquire(path);
        try {
            Resource resource;
            block9: {
                this.refreshSession(adminResolver, false);
                resource = adminResolver.getResource(path);
                if (resource == null) {
                    Resource parent = adminResolver.getResource(parentPath);
                    if (parent == null) {
                        this.sequencer.release(token);
                        token = null;
                        parent = this.safeCreateParent(adminResolver, parentPath, level + 1, parentCreationStrategy);
                        token = this.sequencer.acquire(path);
                        this.refreshSession(adminResolver, false);
                        resource = adminResolver.getResource(path);
                    }
                    if (null == resource) {
                        try {
                            resource = parentCreationStrategy.createParent(adminResolver, parent, separated[1], level);
                            Validate.notNull((Object)resource, (String)("Parent creator didn't create " + path), (Object[])new Object[0]);
                            adminResolver.commit();
                            LOG.debug("Created parent {}", (Object)path);
                        }
                        catch (PersistenceException e) {
                            LOG.info("Creation of parent {} aborted - probably parallel creation {}", (Object)path, (Object)(e.toString() + "/" + String.valueOf(e.getCause())));
                            this.refreshSession(adminResolver, false);
                            resource = adminResolver.getResource(path);
                            if (null != resource) break block9;
                            LOG.error("Bug: creation aborted *and* resource is not there!", (Throwable)e);
                        }
                    }
                }
            }
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            if (null != token) {
                this.sequencer.release(token);
            }
        }
    }

    protected void refreshSession(ResourceResolver resolver, boolean keepChanges) {
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            session.refresh(keepChanges);
        }
        catch (RepositoryException rex) {
            LOG.warn(rex.toString(), (Throwable)rex);
        }
    }

    protected ResourceResolver createAdministrativeResolver() {
        try {
            return this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            throw new SlingException("Configuration problem: we cannot get an administrative resolver ", (Throwable)e);
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindSequencer(SequencerService sequencerService) {
        this.sequencer = sequencerService;
    }

    protected void unbindSequencer(SequencerService sequencerService) {
        if (this.sequencer == sequencerService) {
            this.sequencer = null;
        }
    }
}

