/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import java.util.Calendar;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.jobs.Job;

public interface JobFacade
extends Comparable<JobFacade> {
    public String getTopic();

    public String getId();

    public Object getProperty(String var1);

    public Set<String> getPropertyNames();

    public <T> T getProperty(String var1, Class<T> var2);

    public <T> T getProperty(String var1, T var2);

    public int getRetryCount();

    public int getNumberOfRetries();

    public String getQueueName();

    public String getTargetInstance();

    public Calendar getProcessingStarted();

    public Calendar getCreated();

    public String getCreatedInstance();

    public Job.JobState getJobState();

    public Calendar getFinishedDate();

    public String getResultMessage();

    public String[] getProgressLog();

    public int getProgressStepCount();

    public int getFinishedProgressStep();

    public Calendar getProgressETA();

    public static class AuditJob
    extends AbstractJobFacade {
        public final Resource resource;

        public AuditJob(Resource resource) {
            this.resource = resource;
        }

        protected String getStringProperty(String name) {
            ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
            return (String)valueMap.get(name, (Object)"");
        }

        @Override
        public String getTopic() {
            return this.getStringProperty("event.job.topic");
        }

        @Override
        public String getId() {
            return this.getStringProperty("slingevent:eventId");
        }

        @Override
        public Object getProperty(String name) {
            ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
            return valueMap.get((Object)name);
        }

        @Override
        public Set<String> getPropertyNames() {
            ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
            return valueMap.keySet();
        }

        @Override
        public <T> T getProperty(String name, Class<T> type) {
            ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
            return (T)valueMap.get(name, type);
        }

        @Override
        public <T> T getProperty(String name, T defaultValue) {
            ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
            return (T)valueMap.get(name, defaultValue);
        }

        @Override
        public int getRetryCount() {
            return (Integer)this.getProperty("event.job.retrycount");
        }

        @Override
        public int getNumberOfRetries() {
            return (Integer)this.getProperty("event.job.retries");
        }

        @Override
        public String getQueueName() {
            return (String)this.getProperty("event.job.queuename");
        }

        @Override
        public String getTargetInstance() {
            return (String)this.getProperty("event.job.application");
        }

        @Override
        public Calendar getProcessingStarted() {
            return (Calendar)this.getProperty("event.job.started.time");
        }

        @Override
        public Calendar getCreated() {
            return (Calendar)this.getProperty("slingevent:created");
        }

        @Override
        public String getCreatedInstance() {
            return (String)this.getProperty("slingevent:application");
        }

        @Override
        public Job.JobState getJobState() {
            String enumValue = (String)((Object)this.getProperty("slingevent:finishedState", (Object)String.class));
            if (enumValue == null) {
                if (this.getProcessingStarted() != null) {
                    return Job.JobState.ACTIVE;
                }
                return Job.JobState.QUEUED;
            }
            return Job.JobState.valueOf((String)enumValue);
        }

        @Override
        public Calendar getFinishedDate() {
            return (Calendar)((Object)this.getProperty("slingevent:finishedDate", (Object)Calendar.class));
        }

        @Override
        public String getResultMessage() {
            return (String)((Object)this.getProperty("slingevent:resultMessage", (Object)String.class));
        }

        @Override
        public String[] getProgressLog() {
            return (String[])this.getProperty("slingevent:progressLog", (Object)String[].class);
        }

        @Override
        public int getProgressStepCount() {
            return this.getProperty("slingevent:progressSteps", -1);
        }

        @Override
        public int getFinishedProgressStep() {
            return this.getProperty("slingevent:progressStep", 0);
        }

        @Override
        public Calendar getProgressETA() {
            return (Calendar)((Object)this.getProperty("slingevent:progressETA", (Object)Calendar.class));
        }
    }

    public static class EventJob
    extends AbstractJobFacade {
        public final Job job;

        public EventJob(Job job) {
            this.job = job;
        }

        @Override
        public String getTopic() {
            return this.job.getTopic();
        }

        @Override
        public String getId() {
            return this.job.getId();
        }

        @Override
        public Object getProperty(String name) {
            return this.job.getProperty(name);
        }

        @Override
        public Set<String> getPropertyNames() {
            return this.job.getPropertyNames();
        }

        @Override
        public <T> T getProperty(String name, Class<T> type) {
            return (T)this.job.getProperty(name, type);
        }

        @Override
        public <T> T getProperty(String name, T defaultValue) {
            return (T)this.job.getProperty(name, defaultValue);
        }

        @Override
        public int getRetryCount() {
            return this.job.getRetryCount();
        }

        @Override
        public int getNumberOfRetries() {
            return this.job.getNumberOfRetries();
        }

        @Override
        public String getQueueName() {
            return this.job.getQueueName();
        }

        @Override
        public String getTargetInstance() {
            return this.job.getTargetInstance();
        }

        @Override
        public Calendar getProcessingStarted() {
            return this.job.getProcessingStarted();
        }

        @Override
        public Calendar getCreated() {
            return this.job.getCreated();
        }

        @Override
        public String getCreatedInstance() {
            return this.job.getCreatedInstance();
        }

        @Override
        public Job.JobState getJobState() {
            return this.job.getJobState();
        }

        @Override
        public Calendar getFinishedDate() {
            return this.job.getFinishedDate();
        }

        @Override
        public String getResultMessage() {
            return this.job.getResultMessage();
        }

        @Override
        public String[] getProgressLog() {
            return this.job.getProgressLog();
        }

        @Override
        public int getProgressStepCount() {
            return this.job.getProgressStepCount();
        }

        @Override
        public int getFinishedProgressStep() {
            return this.job.getFinishedProgressStep();
        }

        @Override
        public Calendar getProgressETA() {
            return this.job.getProgressETA();
        }
    }

    public static abstract class AbstractJobFacade
    implements JobFacade {
        @Override
        public int compareTo(JobFacade o2) {
            Calendar j1s = this.getProcessingStarted();
            Calendar j2s = o2.getProcessingStarted();
            return j1s.compareTo(j2s);
        }
    }
}

