/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.filter.StringFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

public class RequestHandle
extends SlingHttpServletRequestWrapper {
    public static RequestHandle use(SlingHttpServletRequest request) {
        RequestHandle handle = request instanceof RequestHandle ? (RequestHandle)request : new RequestHandle(request);
        return handle;
    }

    protected RequestHandle(SlingHttpServletRequest request) {
        super(request);
    }

    public String getSelectors() {
        return this.getSelectors(StringFilter.ALL);
    }

    public String getSelectors(StringFilter filter) {
        return this.getSelectors(null, filter, null);
    }

    public String getSelectors(String[] prepend, StringFilter filter, String[] append) {
        int i;
        String[] selectors = this.getSlingRequest().getRequestPathInfo().getSelectors();
        StringBuilder result = new StringBuilder();
        if (prepend != null && prepend.length > 0) {
            for (i = 0; i < prepend.length; ++i) {
                result.append('.');
                result.append(prepend[i]);
            }
        }
        if (selectors != null && selectors.length > 0) {
            for (i = 0; i < selectors.length; ++i) {
                if (!filter.accept(selectors[i])) continue;
                result.append('.');
                result.append(selectors[i]);
            }
        }
        if (append != null && append.length > 0) {
            for (i = 0; i < append.length; ++i) {
                result.append('.');
                result.append(append[i]);
            }
        }
        return result.toString();
    }

    public String getExtension() {
        String extension = this.getSlingRequest().getRequestPathInfo().getExtension();
        return StringUtils.isBlank((CharSequence)extension) ? "" : "." + extension;
    }
}

