/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;

public class RequestBundle
extends ResourceBundle {
    public static final String ATTRIBUTE_KEY = "composum-core-resource-bundles";
    protected final SlingHttpServletRequest request;
    protected final List<BundleItem> bundles;

    public static synchronized RequestBundle get(SlingHttpServletRequest request) {
        RequestBundle instance = (RequestBundle)request.getAttribute(ATTRIBUTE_KEY);
        if (instance == null) {
            instance = new RequestBundle(request);
            request.setAttribute(ATTRIBUTE_KEY, (Object)instance);
        }
        return instance;
    }

    protected RequestBundle(SlingHttpServletRequest request) {
        this.request = request;
        this.bundles = new ArrayList<BundleItem>();
        this.push(null);
    }

    public synchronized void push(String basename) {
        if (this.bundles.size() > 0) {
            BundleItem last = this.bundles.get(0);
            if (StringUtils.equals((CharSequence)basename, (CharSequence)last.basename)) {
                ++last.stackDepth;
            } else {
                this.pushBundle(basename);
            }
        } else {
            this.pushBundle(basename);
        }
    }

    protected void pushBundle(String basename) {
        BundleItem item = new BundleItem(basename);
        if (this.bundles.size() > 0) {
            BundleItem last = this.bundles.get(0);
            item.bundle.setParent(last.bundle);
        }
        this.bundles.add(0, item);
    }

    public synchronized void pop() {
        if (this.bundles.size() > 0) {
            BundleItem last = this.bundles.get(0);
            if (last.stackDepth > 0) {
                --last.stackDepth;
            } else {
                last.bundle.setParent(null);
                this.bundles.remove(0);
            }
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.bundles.get((int)0).bundle.getObject(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundles.get((int)0).bundle.getKeys();
    }

    protected class BundleItem {
        public final String basename;
        public final BundleWrapper bundle;
        public int stackDepth = 0;

        public BundleItem(String basename) {
            this.basename = basename;
            Locale locale = RequestBundle.this.request.getLocale();
            this.bundle = new BundleWrapper(RequestBundle.this.request.getResourceBundle(basename, locale));
        }
    }

    protected class BundleWrapper
    extends ResourceBundle {
        protected final ResourceBundle bundle;

        public BundleWrapper(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public void setParent(ResourceBundle bundle) {
            super.setParent(bundle);
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.bundle.getObject(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.bundle.getKeys();
        }
    }
}

